/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class ChangeCorrector {
    private final int myLength1;
    private final int myLength2;
    @NotNull
    private final FairDiffIterable myChanges;
    @NotNull
    protected final ProgressIndicator myIndicator;
    @NotNull
    protected final DiffIterableUtil.ChangeBuilder myBuilder;

    ChangeCorrector(int length1, int length2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
        this.myLength1 = length1;
        this.myLength2 = length2;
        this.myChanges = changes2;
        this.myIndicator = indicator;
        this.myBuilder = new DiffIterableUtil.ChangeBuilder(length1, length2);
    }

    @NotNull
    public FairDiffIterable build() {
        this.execute();
        return DiffIterableUtil.fair(this.myBuilder.finish());
    }

    protected void execute() {
        int last1 = 0;
        int last2 = 0;
        for (Range ch : this.myChanges.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                IntPair range1 = this.getOriginalRange1(ch.start1 + i);
                IntPair range2 = this.getOriginalRange2(ch.start2 + i);
                int start1 = range1.val1;
                int start2 = range2.val1;
                int end1 = range1.val2;
                int end2 = range2.val2;
                this.matchGap(last1, start1, last2, start2);
                this.myBuilder.markEqual(start1, start2, end1, end2);
                last1 = end1;
                last2 = end2;
            }
        }
        this.matchGap(last1, this.myLength1, last2, this.myLength2);
    }

    protected abstract void matchGap(int var1, int var2, int var3, int var4);

    protected abstract IntPair getOriginalRange1(int var1);

    protected abstract IntPair getOriginalRange2(int var1);

    public static class SmartLineChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final TIntArrayList myIndexes1;
        @NotNull
        private final TIntArrayList myIndexes2;
        @NotNull
        private final List<? extends ByLine.Line> myLines1;
        @NotNull
        private final List<? extends ByLine.Line> myLines2;

        public SmartLineChangeCorrector(@NotNull TIntArrayList indexes1, @NotNull TIntArrayList indexes2, @NotNull List<? extends ByLine.Line> lines1, @NotNull List<? extends ByLine.Line> lines2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
            super(lines1.size(), lines2.size(), changes2, indicator);
            this.myIndexes1 = indexes1;
            this.myIndexes2 = indexes2;
            this.myLines1 = lines1;
            this.myLines2 = lines2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myLines1, this.myLines2, start1, start2, end1, end2);
            List<? extends ByLine.Line> inner1 = this.myLines1.subList(expand.start1, expand.end1);
            List<? extends ByLine.Line> inner2 = this.myLines2.subList(expand.start2, expand.end2);
            FairDiffIterable innerChanges = DiffIterableUtil.diff(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }

        @Override
        protected IntPair getOriginalRange1(int index) {
            int offset = this.myIndexes1.get(index);
            return new IntPair(offset, offset + 1);
        }

        @Override
        protected IntPair getOriginalRange2(int index) {
            int offset = this.myIndexes2.get(index);
            return new IntPair(offset, offset + 1);
        }
    }

    public static class DefaultCharChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final ByChar.CodePointsOffsets myCodePoints1;
        @NotNull
        private final ByChar.CodePointsOffsets myCodePoints2;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public DefaultCharChangeCorrector(@NotNull ByChar.CodePointsOffsets codePoints1, @NotNull ByChar.CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
            super(text1.length(), text2.length(), changes2, indicator);
            this.myCodePoints1 = codePoints1;
            this.myCodePoints2 = codePoints2;
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            CharSequence inner1 = this.myText1.subSequence(start1, end1);
            CharSequence inner2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable innerChanges = ByChar.compare(inner1, inner2, this.myIndicator);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + chunk.start1, start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
        }

        @Override
        protected IntPair getOriginalRange1(int index) {
            int startOffset = this.myCodePoints1.charOffset(index);
            int endOffset = this.myCodePoints1.charOffsetAfter(index);
            return new IntPair(startOffset, endOffset);
        }

        @Override
        protected IntPair getOriginalRange2(int index) {
            int startOffset = this.myCodePoints2.charOffset(index);
            int endOffset = this.myCodePoints2.charOffsetAfter(index);
            return new IntPair(startOffset, endOffset);
        }
    }
}

