/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.MergeResolveUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonMergeUtil {
    @NotNull
    public static List<MergeRange> buildSimple(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull ProgressIndicator indicator) {
        assert (fragments1.getLength1() == fragments2.getLength1());
        return new FairMergeBuilder().execute(fragments1, fragments2);
    }

    @NotNull
    public static List<MergeRange> buildMerge(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull SideEquality trueEquality, @NotNull ProgressIndicator indicator) {
        assert (fragments1.getLength1() == fragments2.getLength1());
        return new FairMergeBuilder(trueEquality).execute(fragments1, fragments2);
    }

    @Nullable
    public static CharSequence tryResolveConflict(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        if (Registry.is((String)"diff.merge.resolve.conflict.action.use.greedy.approach")) {
            return MergeResolveUtil.tryGreedyResolve(leftText, baseText, rightText);
        }
        return MergeResolveUtil.tryResolve(leftText, baseText, rightText);
    }

    static interface SideEquality {
        public boolean equals(int var1, int var2, int var3);
    }

    private static class IgnoringChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final SideEquality myTrueEquality;

        private IgnoringChangeBuilder(@NotNull SideEquality trueEquality) {
            this.myTrueEquality = trueEquality;
        }

        @Override
        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            MergeRange lastChange = (MergeRange)ContainerUtil.getLastItem((List)this.myChanges);
            int unchangedStart1 = lastChange != null ? lastChange.end1 : 0;
            int unchangedStart2 = lastChange != null ? lastChange.end2 : 0;
            int unchangedStart3 = lastChange != null ? lastChange.end3 : 0;
            this.addIgnoredChanges(unchangedStart1, unchangedStart2, unchangedStart3, start1, start2, start3);
            this.addChange(start1, start2, start3, end1, end2, end3);
        }

        private void addIgnoredChanges(int start1, int start2, int start3, int end1, int end2, int end3) {
            int count = end2 - start2;
            assert (end1 - start1 == count);
            assert (end3 - start3 == count);
            int firstIgnoredCount = -1;
            for (int i = 0; i < count; ++i) {
                boolean previousAreIgnored;
                boolean isIgnored = !this.myTrueEquality.equals(start1 + i, start2 + i, start3 + i);
                boolean bl = previousAreIgnored = firstIgnoredCount != -1;
                if (isIgnored && !previousAreIgnored) {
                    firstIgnoredCount = i;
                }
                if (isIgnored || !previousAreIgnored) continue;
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + i, start2 + i, start3 + i);
                firstIgnoredCount = -1;
            }
            if (firstIgnoredCount != -1) {
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + count, start2 + count, start3 + count);
            }
        }
    }

    private static class ChangeBuilder {
        @NotNull
        protected final List<MergeRange> myChanges = new ArrayList<MergeRange>();
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private int myIndex3 = 0;

        private ChangeBuilder() {
        }

        protected void addChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (start1 == end1 && start2 == end2 && start3 == end3) {
                return;
            }
            this.myChanges.add(new MergeRange(start1, end1, start2, end2, start3, end3));
        }

        public void markEqual(int start1, int start2, int start3, int end1, int end2, int end3) {
            assert (this.myIndex1 <= start1);
            assert (this.myIndex2 <= start2);
            assert (this.myIndex3 <= start3);
            assert (start1 <= end1);
            assert (start2 <= end2);
            assert (start3 <= end3);
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, start1, start2, start3);
            this.myIndex1 = end1;
            this.myIndex2 = end2;
            this.myIndex3 = end3;
        }

        @NotNull
        public List<MergeRange> finish(int length1, int length2, int length3) {
            assert (this.myIndex1 <= length1);
            assert (this.myIndex2 <= length2);
            assert (this.myIndex3 <= length3);
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, length1, length2, length3);
            return this.myChanges;
        }

        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            this.addChange(start1, start2, start3, end1, end2, end3);
        }
    }

    private static class FairMergeBuilder {
        @NotNull
        private final ChangeBuilder myChangesBuilder;

        private FairMergeBuilder() {
            this.myChangesBuilder = new ChangeBuilder();
        }

        private FairMergeBuilder(@NotNull SideEquality trueEquality) {
            this.myChangesBuilder = new IgnoringChangeBuilder(trueEquality);
        }

        @NotNull
        public List<MergeRange> execute(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            PeekableIteratorWrapper unchanged1 = new PeekableIteratorWrapper(fragments1.unchanged());
            PeekableIteratorWrapper unchanged2 = new PeekableIteratorWrapper(fragments2.unchanged());
            while (unchanged1.hasNext() && unchanged2.hasNext()) {
                Side side = this.add((Range)unchanged1.peek(), (Range)unchanged2.peek());
                ((PeekableIterator)side.select((Object)unchanged1, (Object)unchanged2)).next();
            }
            return this.myChangesBuilder.finish(fragments1.getLength2(), fragments1.getLength1(), fragments2.getLength2());
        }

        @NotNull
        private Side add(@NotNull Range range1, @NotNull Range range2) {
            int start1 = range1.start1;
            int end1 = range1.end1;
            int start2 = range2.start1;
            int end2 = range2.end1;
            if (end1 <= start2) {
                return Side.LEFT;
            }
            if (end2 <= start1) {
                return Side.RIGHT;
            }
            int startBase = Math.max(start1, start2);
            int endBase = Math.min(end1, end2);
            int count = endBase - startBase;
            int startShift1 = startBase - start1;
            int startShift2 = startBase - start2;
            int startLeft = range1.start2 + startShift1;
            int endLeft = startLeft + count;
            int startRight = range2.start2 + startShift2;
            int endRight = startRight + count;
            this.myChangesBuilder.markEqual(startLeft, startBase, startRight, endLeft, endBase, endRight);
            return Side.fromLeft((end1 <= end2 ? 1 : 0) != 0);
        }
    }
}

