/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffChangeDiffIterable;
import com.intellij.diff.comparison.iterables.DiffFragmentsDiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.InvertedDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.RangesDiffIterable;
import com.intellij.diff.comparison.iterables.SubiterableDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffIterableUtil {
    private static boolean SHOULD_VERIFY_ITERABLE = Registry.is((String)"diff.verify.iterable");

    @NotNull
    public static FairDiffIterable diff(@NotNull int[] data1, @NotNull int[] data2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges((int[])data1, (int[])data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException e) {
            throw new DiffTooBigException();
        }
    }

    @NotNull
    public static <T> FairDiffIterable diff(@NotNull T[] data1, @NotNull T[] data2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges((Object[])data1, (Object[])data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException e) {
            throw new DiffTooBigException();
        }
    }

    @NotNull
    public static <T> FairDiffIterable diff(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return DiffIterableUtil.diff(objects1.toArray(), objects2.toArray(), indicator);
    }

    @NotNull
    public static DiffIterable create(@Nullable Diff.Change change, int length1, int length2) {
        DiffChangeDiffIterable iterable = new DiffChangeDiffIterable(change, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @NotNull
    public static DiffIterable createFragments(@NotNull List<? extends DiffFragment> fragments, int length1, int length2) {
        DiffFragmentsDiffIterable iterable = new DiffFragmentsDiffIterable(fragments, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @NotNull
    public static DiffIterable create(@NotNull List<? extends Range> ranges, int length1, int length2) {
        RangesDiffIterable iterable = new RangesDiffIterable(ranges, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @NotNull
    public static DiffIterable createUnchanged(@NotNull List<? extends Range> ranges, int length1, int length2) {
        DiffIterable invert2 = DiffIterableUtil.invert(DiffIterableUtil.create(ranges, length1, length2));
        DiffIterableUtil.verify(invert2);
        return invert2;
    }

    @NotNull
    public static DiffIterable invert(@NotNull DiffIterable iterable) {
        InvertedDiffIterableWrapper wrapper2 = new InvertedDiffIterableWrapper(iterable);
        DiffIterableUtil.verify(wrapper2);
        return wrapper2;
    }

    @NotNull
    public static FairDiffIterable fair(@NotNull DiffIterable iterable) {
        if (iterable instanceof FairDiffIterable) {
            return (FairDiffIterable)iterable;
        }
        FairDiffIterableWrapper wrapper2 = new FairDiffIterableWrapper(iterable);
        DiffIterableUtil.verifyFair(wrapper2);
        return wrapper2;
    }

    @NotNull
    public static DiffIterable subiterable(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
        return new SubiterableDiffIterable(iterable, start1, end1, start2, end2);
    }

    @NotNull
    public static Iterable<Pair<Range, Boolean>> iterateAll(final @NotNull DiffIterable iterable) {
        return () -> new Iterator<Pair<Range, Boolean>>(){
            @Nullable
            private Range lastChanged;
            @Nullable
            private Range lastUnchanged;
            @NotNull
            private final Iterator myChanges;
            @NotNull
            private final Iterator myUnchanged;
            {
                this.myChanges = iterable.changes();
                this.myUnchanged = iterable.unchanged();
                this.lastChanged = this.myChanges.hasNext() ? (Range)this.myChanges.next() : null;
                this.lastUnchanged = this.myUnchanged.hasNext() ? (Range)this.myUnchanged.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.lastChanged != null || this.lastUnchanged != null;
            }

            @Override
            public Pair<Range, Boolean> next() {
                boolean equals;
                if (this.lastChanged == null) {
                    equals = true;
                } else if (this.lastUnchanged == null) {
                    equals = false;
                } else {
                    boolean bl = equals = this.lastUnchanged.start1 < this.lastChanged.start1 || this.lastUnchanged.start2 < this.lastChanged.start2;
                }
                if (equals) {
                    Range range2 = this.lastUnchanged;
                    this.lastUnchanged = this.myUnchanged.hasNext() ? (Range)this.myUnchanged.next() : null;
                    return Pair.create((Object)range2, (Object)true);
                }
                Range range3 = this.lastChanged;
                this.lastChanged = this.myChanges.hasNext() ? (Range)this.myChanges.next() : null;
                return Pair.create((Object)range3, (Object)false);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void setVerifyEnabled(boolean value) {
        SHOULD_VERIFY_ITERABLE = value;
    }

    private static boolean isVerifyEnabled() {
        return SHOULD_VERIFY_ITERABLE;
    }

    public static void verify(@NotNull DiffIterable iterable) {
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable.iterateChanges());
        DiffIterableUtil.verify(iterable.iterateUnchanged());
        DiffIterableUtil.verifyFullCover(iterable);
    }

    public static void verifyFair(@NotNull DiffIterable iterable) {
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable);
        for (Range range2 : iterable.iterateUnchanged()) {
            assert (range2.end1 - range2.start1 == range2.end2 - range2.start2);
        }
    }

    private static void verify(@NotNull Iterable<? extends Range> iterable) {
        for (Range range2 : iterable) {
            assert (range2.start1 <= range2.end1);
            assert (range2.start2 <= range2.end2);
            assert (range2.start1 != range2.end1 || range2.start2 != range2.end2);
        }
    }

    private static void verifyFullCover(@NotNull DiffIterable iterable) {
        int last1 = 0;
        int last2 = 0;
        Boolean lastEquals = null;
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range2 = (Range)pair.first;
            Boolean equal = (Boolean)pair.second;
            assert (last1 == range2.start1);
            assert (last2 == range2.start2);
            assert (!Comparing.equal(lastEquals, (Object)equal));
            last1 = range2.end1;
            last2 = range2.end2;
            lastEquals = equal;
        }
        assert (last1 == iterable.getLength1());
        assert (last2 == iterable.getLength2());
    }

    @NotNull
    public static <T> List<LineRangeData> extractDataRanges(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull DiffIterable iterable) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            int i;
            Range range2 = (Range)pair.first;
            boolean equals = (Boolean)pair.second;
            ArrayList<T> data1 = new ArrayList<T>();
            ArrayList<T> data2 = new ArrayList<T>();
            for (i = range2.start1; i < range2.end1; ++i) {
                data1.add(objects1.get(i));
            }
            for (i = range2.start2; i < range2.end2; ++i) {
                data2.add(objects2.get(i));
            }
            result2.add(new LineRangeData(data1, data2, equals));
        }
        return result2;
    }

    public static class LineRangeData<T> {
        public final boolean equals;
        @NotNull
        public final List<T> objects1;
        @NotNull
        public final List<T> objects2;

        public LineRangeData(@NotNull List<T> objects1, @NotNull List<T> objects2, boolean equals) {
            this.equals = equals;
            this.objects1 = objects1;
            this.objects2 = objects2;
        }
    }

    public static class ExpandChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final List<?> myObjects1;
        @NotNull
        private final List<?> myObjects2;

        public ExpandChangeBuilder(@NotNull List<?> objects1, @NotNull List<?> objects2) {
            super(objects1.size(), objects2.size());
            this.myObjects1 = objects1;
            this.myObjects2 = objects2;
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            Range range2 = TrimUtil.expand(this.myObjects1, this.myObjects2, start1, start2, end1, end2);
            if (!range2.isEmpty()) {
                super.addChange(range2.start1, range2.start2, range2.end1, range2.end2);
            }
        }
    }

    public static class ChangeBuilder
    extends ChangeBuilderBase {
        @Nullable
        private Diff.Change myFirstChange;
        @Nullable
        private Diff.Change myLastChange;

        public ChangeBuilder(int length1, int length2) {
            super(length1, length2);
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            Diff.Change change = new Diff.Change(start1, start2, end1 - start1, end2 - start2, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
        }

        @NotNull
        public DiffIterable finish() {
            this.doFinish();
            return DiffIterableUtil.create(this.myFirstChange, this.getLength1(), this.getLength2());
        }
    }

    public static abstract class ChangeBuilderBase {
        private final int myLength1;
        private final int myLength2;
        private int myIndex1 = 0;
        private int myIndex2 = 0;

        public ChangeBuilderBase(int length1, int length2) {
            this.myLength1 = length1;
            this.myLength2 = length2;
        }

        public int getIndex1() {
            return this.myIndex1;
        }

        public int getIndex2() {
            return this.myIndex2;
        }

        public int getLength1() {
            return this.myLength1;
        }

        public int getLength2() {
            return this.myLength2;
        }

        public void markEqual(int index1, int index2) {
            this.markEqual(index1, index2, 1);
        }

        public void markEqual(int index1, int index2, int count) {
            this.markEqual(index1, index2, index1 + count, index2 + count);
        }

        public void markEqual(int index1, int index2, int end1, int end2) {
            if (index1 == end1 && index2 == end2) {
                return;
            }
            assert (this.myIndex1 <= index1);
            assert (this.myIndex2 <= index2);
            assert (index1 <= end1);
            assert (index2 <= end2);
            if (this.myIndex1 != index1 || this.myIndex2 != index2) {
                this.addChange(this.myIndex1, this.myIndex2, index1, index2);
            }
            this.myIndex1 = end1;
            this.myIndex2 = end2;
        }

        protected void doFinish() {
            assert (this.myIndex1 <= this.myLength1);
            assert (this.myIndex2 <= this.myLength2);
            if (this.myLength1 != this.myIndex1 || this.myLength2 != this.myIndex2) {
                this.addChange(this.myIndex1, this.myIndex2, this.myLength1, this.myLength2);
                this.myIndex1 = this.myLength1;
                this.myIndex2 = this.myLength2;
            }
        }

        protected abstract void addChange(int var1, int var2, int var3, int var4);
    }
}

