/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryContentImpl
extends DiffContentBase
implements DirectoryContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @Nullable
    private final VirtualFile myHighlightFile;

    public DirectoryContentImpl(@Nullable Project project, @NotNull VirtualFile file2) {
        this(project, file2, file2);
    }

    public DirectoryContentImpl(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        assert (file2.isValid() && file2.isDirectory());
        this.myProject = project;
        this.myFile = file2;
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.myHighlightFile)) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public FileType getContentType() {
        return null;
    }
}

