/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2) {
        this(project, document, file2, file2);
    }

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        super(project, document, file2.getFileType(), highlightFile, FileDocumentContentImpl.getSeparator(file2), file2.getCharset(), file2.getBOM() != null);
        this.myFile = file2;
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file2) {
        String s = LoadTextUtil.detectLineSeparator(file2, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

