/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestChainProcessor
extends CacheDiffRequestProcessor<DiffRequestProducer> {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestChainProcessor.class);
    @NotNull
    private final DiffRequestChain myRequestChain;

    public CacheDiffRequestChainProcessor(@Nullable Project project, @NotNull DiffRequestChain requestChain) {
        super(project, (UserDataHolder)requestChain);
        this.myRequestChain = requestChain;
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(true);
            ((AsyncDiffRequestChain)this.myRequestChain).addListener(new MyChangeListener(), this);
        }
    }

    @Override
    protected void onDispose() {
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(false);
        }
        super.onDispose();
    }

    @Override
    @NotNull
    protected String getRequestName(@NotNull DiffRequestProducer producer) {
        return producer.getName();
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        List requests = this.myRequestChain.getRequests();
        int index = this.myRequestChain.getIndex();
        if (index < 0 || index >= requests.size()) {
            return null;
        }
        return (DiffRequestProducer)requests.get(index);
    }

    @Override
    @NotNull
    protected DiffRequest loadRequest(@NotNull DiffRequestProducer producer, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
        return producer.process((UserDataHolder)this.getContext(), indicator);
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        return this.myRequestChain;
    }

    @Override
    @NotNull
    protected List<AnAction> getNavigationActions() {
        return ContainerUtil.list((Object[])new AnAction[]{new DiffRequestProcessor.MyPrevDifferenceAction(this), new DiffRequestProcessor.MyNextDifferenceAction(this), new DiffRequestProcessor.MyOpenInEditorAction(this), Separator.getInstance(), new DiffRequestProcessor.MyPrevChangeAction(this), new DiffRequestProcessor.MyNextChangeAction(this), this.createGoToChangeAction()});
    }

    @Override
    protected boolean hasNextChange() {
        return this.myRequestChain.getIndex() < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange() {
        return this.myRequestChain.getIndex() > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() + 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        this.myRequestChain.setIndex(this.myRequestChain.getIndex() - 1);
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @NotNull
    private AnAction createGoToChangeAction() {
        return GoToChangePopupBuilder.create(this.myRequestChain, (Consumer<Integer>)((Consumer)index -> {
            if (index >= 0 && index.intValue() != this.myRequestChain.getIndex()) {
                this.myRequestChain.setIndex(index.intValue());
                this.updateRequest();
            }
        }));
    }

    private class MyChangeListener
    implements AsyncDiffRequestChain.Listener {
        private MyChangeListener() {
        }

        @Override
        public void onRequestsLoaded() {
            CacheDiffRequestChainProcessor.this.dropCaches();
            CacheDiffRequestChainProcessor.this.updateRequest(true);
        }
    }
}

