/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LangDiffIgnoredRangeProvider
implements DiffIgnoredRangeProvider {
    protected abstract boolean accepts(@NotNull Project var1, @NotNull Language var2);

    @NotNull
    protected abstract List<TextRange> computeIgnoredRanges(@NotNull Project var1, @NotNull CharSequence var2, @NotNull Language var3);

    @Override
    public final boolean accepts(@Nullable Project project, @NotNull DiffContent content) {
        if (project == null) {
            return false;
        }
        Language language = LangDiffIgnoredRangeProvider.getLanguage(project, content);
        if (language == null) {
            return false;
        }
        return this.accepts(project, language);
    }

    @Override
    @NotNull
    public List<TextRange> getIgnoredRanges(@Nullable Project project, @NotNull CharSequence text, @NotNull DiffContent content) {
        assert (project != null);
        Language language = LangDiffIgnoredRangeProvider.getLanguage(project, content);
        assert (language != null);
        return this.computeIgnoredRanges(project, text, language);
    }

    @Nullable
    private static Language getLanguage(@NotNull Project project, @NotNull DiffContent content) {
        VirtualFile highlightFile;
        Language language = (Language)content.getUserData(DiffUserDataKeys.LANGUAGE);
        if (language != null) {
            return language;
        }
        FileType type = content.getContentType();
        if (type instanceof LanguageFileType) {
            language = ((LanguageFileType)type).getLanguage();
        }
        if (language != null && content instanceof DocumentContent && (highlightFile = ((DocumentContent)content).getHighlightFile()) != null) {
            language = LanguageSubstitutors.INSTANCE.substituteLanguage(language, highlightFile, project);
        }
        return language;
    }
}

