/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMergeTool
implements MergeTool {
    public static final ErrorMergeTool INSTANCE = new ErrorMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        return new MyViewer(context, request);
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        return true;
    }

    private static class MyViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final MergeRequest myMergeRequest;
        @NotNull
        private final JPanel myPanel;

        MyViewer(@NotNull MergeContext context, @NotNull MergeRequest request) {
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)this.createComponent(), "Center");
        }

        @NotNull
        private JComponent createComponent() {
            return DiffUtil.createMessagePanel("Can't show diff");
        }

        @NotNull
        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            return new MergeTool.ToolbarComponents();
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            if (result2 == MergeResult.RESOLVED) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle(result2, this.myMergeRequest, this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myMergeContext.finishMerge(result2);
                }
            };
        }

        public void dispose() {
        }
    }
}

