/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.SimpleLineStatusTracker;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final TextMergeRequest myMergeRequest;
    @NotNull
    private final MyThreesideViewer myViewer;

    public TextMergeViewer(@NotNull MergeContext context, @NotNull TextMergeRequest request) {
        this.myMergeContext = context;
        this.myMergeRequest = request;
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), TextMergeViewer.getDiffContents(this.myMergeRequest), TextMergeViewer.getDiffContentTitles(this.myMergeRequest));
        diffRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS, (Object)new boolean[]{true, false, true});
        this.myViewer = new MyThreesideViewer(diffContext, (ContentDiffRequest)diffRequest);
    }

    @NotNull
    private static List<DiffContent> getDiffContents(@NotNull TextMergeRequest mergeRequest) {
        List contents = mergeRequest.getContents();
        DocumentContent left = (DocumentContent)ThreeSide.LEFT.select(contents);
        DocumentContent right = (DocumentContent)ThreeSide.RIGHT.select(contents);
        DocumentContent output = mergeRequest.getOutputContent();
        return ContainerUtil.list((Object[])new DiffContent[]{left, output, right});
    }

    @NotNull
    private static List<String> getDiffContentTitles(@NotNull TextMergeRequest mergeRequest) {
        List<String> titles = MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        titles.set(ThreeSide.BASE.getIndex(), DiffBundle.message((String)"merge.version.title.merged.result", (Object[])new Object[0]));
        return titles;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myViewer.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
        FrameDiffTool.ToolbarComponents init = this.myViewer.init();
        components.statusPanel = init.statusPanel;
        components.toolbarActions = init.toolbarActions;
        components.closeHandler = () -> {
            if (this.myViewer.myContentModified) {
                return MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext);
            }
            return true;
        };
        return components;
    }

    @Nullable
    public Action getResolveAction(@NotNull MergeResult result2) {
        return this.myViewer.getResolveAction(result2);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public MyThreesideViewer getViewer() {
        return this.myViewer;
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        InnerChunkData(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<Document> documents) {
            return ThreeSide.map(side -> {
                int endLine;
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
        }
    }

    public class MyThreesideViewer
    extends ThreesideTextDiffViewerEx {
        @NotNull
        private final MergeModelBase myModel;
        @NotNull
        private final ModifierProvider myModifierProvider;
        @NotNull
        private final MyInnerDiffWorker myInnerDiffWorker;
        @NotNull
        private final SimpleLineStatusTracker myLineStatusTracker;
        @NotNull
        private final TextDiffProviderBase myTextDiffProvider;
        @NotNull
        private final List<TextMergeChange> myAllMergeChanges;
        @NotNull
        private IgnorePolicy myCurrentIgnorePolicy;
        private boolean myInitialRediffStarted;
        private boolean myInitialRediffFinished;
        private boolean myContentModified;

        public MyThreesideViewer(@NotNull DiffContext context, ContentDiffRequest request) {
            super(context, request);
            this.myAllMergeChanges = new ArrayList<TextMergeChange>();
            this.myModel = new MyMergeModel(this.getProject(), this.getEditor().getDocument());
            this.myModifierProvider = new ModifierProvider();
            this.myInnerDiffWorker = new MyInnerDiffWorker();
            this.myLineStatusTracker = new SimpleLineStatusTracker(this.getProject(), this.getEditor().getDocument(), (Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer>)((Function1)x$0 -> new MyLineStatusMarkerRenderer((LineStatusTrackerBase<?>)x$0)));
            this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), () -> {
                this.restartMergeResolveIfNeeded();
                this.myInnerDiffWorker.onSettingsChanged();
            }, (Disposable)this, (IgnorePolicy[])ContainerUtil.ar((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES}), (HighlightPolicy[])ContainerUtil.ar((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD}));
            this.myCurrentIgnorePolicy = this.myTextDiffProvider.getIgnorePolicy();
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new ApplySelectedChangesAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.LEFT, true), this.myPanel);
            DiffUtil.registerAction(new IgnoreSelectedChangesSideAction(Side.RIGHT, true), this.myPanel);
            DiffUtil.registerAction(new ResolveSelectedConflictsAction(true), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(false), this.myPanel);
            DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(true), this.myPanel);
            ProxyUndoRedoAction.register(this.getProject(), this.getEditor(), this.myContentPanel);
        }

        @Override
        protected void onInit() {
            super.onInit();
            this.myModifierProvider.init();
        }

        @Override
        protected void onDispose() {
            Disposer.dispose((Disposable)this.myModel);
            this.myLineStatusTracker.release();
            this.myInnerDiffWorker.disable();
            super.onDispose();
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            DefaultActionGroup diffGroup = new DefaultActionGroup("Compare Contents", true);
            diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
            diffGroup.add((AnAction)Separator.create((String)"Compare Contents"));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE, true));
            diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, true));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.LEFT));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.BASE));
            diffGroup.add((AnAction)new ShowDiffWithBaseAction(ThreeSide.RIGHT));
            group.add((AnAction)diffGroup);
            group.add((AnAction)new Separator("Apply non-conflicting changes:"));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.LEFT, "Left"));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.BASE, "All"));
            group.add((AnAction)new ApplyNonConflictsAction(ThreeSide.RIGHT, "Right"));
            group.add((AnAction)new MagicResolvedConflictsAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(this.myTextDiffProvider.getToolbarActions());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            group.add((AnAction)this.myEditorSettingsAction);
            return group;
        }

        @Override
        @NotNull
        protected List<AnAction> createEditorPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>();
            group.add(new ApplySelectedChangesAction(Side.LEFT, false));
            group.add(new ApplySelectedChangesAction(Side.RIGHT, false));
            group.add(new ResolveSelectedChangesAction(Side.LEFT));
            group.add(new ResolveSelectedChangesAction(Side.RIGHT));
            group.add(new IgnoreSelectedChangesSideAction(Side.LEFT, false));
            group.add(new IgnoreSelectedChangesSideAction(Side.RIGHT, false));
            group.add(new ResolveSelectedConflictsAction(false));
            group.add(new IgnoreSelectedChangesAction());
            group.add((AnAction)Separator.getInstance());
            group.addAll(TextDiffViewerUtil.createEditorPopupActions());
            return group;
        }

        @Override
        @Nullable
        protected List<AnAction> createPopupActions() {
            ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
            return group;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result2) {
            String caption = MergeUtil.getResolveActionTitle(result2, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((result2 == MergeResult.LEFT || result2 == MergeResult.RIGHT) && MyThreesideViewer.this.myContentModified && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.message", (Object[])new Object[]{result2 == MergeResult.LEFT ? 0 : 1}), (String)DiffBundle.message((String)"merge.dialog.resolve.side.with.discard.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.RESOLVED && (MyThreesideViewer.this.getChangesCount() > 0 || MyThreesideViewer.this.getConflictsCount() > 0) && Messages.showYesNoDialog((Component)MyThreesideViewer.this.myPanel.getRootPane(), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MyThreesideViewer.this.getChangesCount(), MyThreesideViewer.this.getConflictsCount()}), (String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                        return;
                    }
                    if (result2 == MergeResult.CANCEL && MyThreesideViewer.this.myContentModified && !MergeUtil.showExitWithoutApplyingChangesDialog(TextMergeViewer.this, (MergeRequest)TextMergeViewer.this.myMergeRequest, TextMergeViewer.this.myMergeContext)) {
                        return;
                    }
                    MyThreesideViewer.this.destroyChangedBlocks();
                    TextMergeViewer.this.myMergeContext.finishMerge(result2);
                }
            };
        }

        private void restartMergeResolveIfNeeded() {
            if (this.myTextDiffProvider.getIgnorePolicy().equals((Object)this.myCurrentIgnorePolicy)) {
                return;
            }
            if (!this.myInitialRediffFinished) {
                ApplicationManager.getApplication().invokeLater(() -> this.restartMergeResolveIfNeeded());
                return;
            }
            if (this.myContentModified && Messages.showYesNoDialog((Project)this.myProject, (String)"This operation will reset all applied changes. Are you sure you want to continue?", (String)"Restart Visual Merge", (Icon)Messages.getQuestionIcon()) != 0) {
                this.getTextSettings().setIgnorePolicy(this.myCurrentIgnorePolicy);
                return;
            }
            this.myInitialRediffFinished = false;
            this.doRediff();
        }

        private boolean setInitialOutputContent() {
            Document baseDocument = ((DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents())).getDocument();
            Document outputDocument = TextMergeViewer.this.myMergeRequest.getOutputContent().getDocument();
            return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), "Init merge content", () -> {
                outputDocument.setText(baseDocument.getCharsSequence());
                DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
                if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                    this.myLineStatusTracker.setBaseRevision(baseDocument.getCharsSequence());
                    this.getEditor().getGutterComponentEx().setForceShowRightFreePaintersArea(true);
                }
            });
        }

        @Override
        public void rediff(boolean trySync) {
            if (this.myInitialRediffStarted) {
                return;
            }
            this.myInitialRediffStarted = true;
            assert (this.myAllMergeChanges.isEmpty());
            this.doRediff();
        }

        @Override
        @NotNull
        protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
            throw new UnsupportedOperationException();
        }

        private void doRediff() {
            this.myStatusPanel.setBusy(true);
            this.myInnerDiffWorker.disable();
            this.getEditor().setViewer(true);
            ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), "Computing Differences...", true){
                private Runnable myCallback;

                public void run(@NotNull ProgressIndicator indicator) {
                    this.myCallback = MyThreesideViewer.this.doPerformRediff(indicator);
                }

                public void onCancel() {
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onThrowable(@NotNull Throwable error) {
                    LOG.error(error);
                    TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.CANCEL);
                }

                public void onSuccess() {
                    if (MyThreesideViewer.this.isDisposed()) {
                        return;
                    }
                    this.myCallback.run();
                }
            }));
        }

        @NotNull
        protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
            try {
                indicator.checkCanceled();
                IgnorePolicy ignorePolicy = this.myTextDiffProvider.getIgnorePolicy();
                List contents = TextMergeViewer.this.myMergeRequest.getContents();
                List sequences = (List)ReadAction.compute(() -> {
                    indicator.checkCanceled();
                    return ContainerUtil.map((Collection)contents, content -> content.getDocument().getImmutableCharSequence());
                });
                List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
                ComparisonManager manager = ComparisonManager.getInstance();
                List lineFragments = manager.mergeLines((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), ignorePolicy.getComparisonPolicy(), indicator);
                List conflictTypes = ContainerUtil.map((Collection)lineFragments, fragment -> DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, ignorePolicy.getComparisonPolicy()));
                return () -> this.apply(lineFragments, conflictTypes, ignorePolicy);
            }
            catch (DiffTooBigException e) {
                return this.applyNotification(DiffNotifications.createDiffTooBig());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                return () -> {
                    this.clearDiffPresentation();
                    this.myPanel.setErrorContent();
                };
            }
        }

        private void apply(@NotNull List<MergeLineFragment> fragments, @NotNull List<MergeConflictType> conflictTypes, @NotNull IgnorePolicy ignorePolicy) {
            this.clearDiffPresentation();
            this.resetChangeCounters();
            boolean success2 = this.setInitialOutputContent();
            if (!success2) {
                fragments = Collections.emptyList();
                conflictTypes = Collections.emptyList();
                this.myPanel.addNotification(DiffNotifications.createNotification("Can't resolve conflicts in a read-only file"));
            }
            this.myModel.setChanges(ContainerUtil.map(fragments, f -> new LineRange(f.getStartLine(ThreeSide.BASE), f.getEndLine(ThreeSide.BASE))));
            for (int index = 0; index < fragments.size(); ++index) {
                MergeLineFragment fragment = (MergeLineFragment)fragments.get(index);
                MergeConflictType conflictType = conflictTypes.get(index);
                TextMergeChange change = new TextMergeChange(index, fragment, conflictType, TextMergeViewer.this);
                this.myAllMergeChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
            this.getEditor().setViewer(false);
            this.myInnerDiffWorker.onEverythingChanged();
            this.myInitialRediffFinished = true;
            this.myContentModified = false;
            this.myCurrentIgnorePolicy = ignorePolicy;
            if (TextMergeViewer.this.myViewer.getTextSettings().isAutoApplyNonConflictedChanges() && this.hasNonConflictedChanges(ThreeSide.BASE)) {
                this.applyNonConflictedChanges(ThreeSide.BASE);
            }
        }

        @Override
        protected void destroyChangedBlocks() {
            super.destroyChangedBlocks();
            this.myInnerDiffWorker.stop();
            for (TextMergeChange change : this.myAllMergeChanges) {
                change.destroy();
            }
            this.myAllMergeChanges.clear();
            this.myModel.setChanges(Collections.emptyList());
        }

        @Override
        protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
            super.onBeforeDocumentChange(e);
            if (this.myInitialRediffFinished) {
                this.myContentModified = true;
            }
        }

        public void repaintDividers() {
            this.myContentPanel.repaintDividers();
        }

        private void onChangeResolved(@NotNull TextMergeChange change) {
            if (change.isResolved()) {
                this.onChangeRemoved(change);
            } else {
                this.onChangeAdded(change);
            }
            if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
                LOG.assertTrue(ContainerUtil.and(this.getAllChanges(), TextMergeChange::isResolved));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    JComponent component = this.getEditor().getComponent();
                    RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, JBUI.scale((int)5)));
                    String message = DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]);
                    DiffUtil.showSuccessPopup(message, point, (Disposable)this, () -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        this.destroyChangedBlocks();
                        TextMergeViewer.this.myMergeContext.finishMerge(MergeResult.RESOLVED);
                    });
                });
            }
        }

        @NotNull
        public MergeModelBase getModel() {
            return this.myModel;
        }

        @NotNull
        public List<TextMergeChange> getAllChanges() {
            return this.myAllMergeChanges;
        }

        @NotNull
        public List<TextMergeChange> getChanges() {
            return ContainerUtil.filter(this.myAllMergeChanges, mergeChange -> !mergeChange.isResolved());
        }

        @Override
        @NotNull
        protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
            return new MyDividerPaintable(side);
        }

        @NotNull
        public ModifierProvider getModifierProvider() {
            return this.myModifierProvider;
        }

        @NotNull
        public EditorEx getEditor() {
            return this.getEditor(ThreeSide.BASE);
        }

        public boolean executeMergeCommand(@Nullable String commandName, boolean underBulkUpdate, @Nullable List<TextMergeChange> affected, @NotNull Runnable task2) {
            this.myContentModified = true;
            TIntArrayList affectedIndexes = null;
            if (affected != null) {
                affectedIndexes = new TIntArrayList(affected.size());
                for (TextMergeChange change : affected) {
                    affectedIndexes.add(change.getIndex());
                }
            }
            return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, affectedIndexes, task2);
        }

        public boolean executeMergeCommand(@Nullable String commandName, @Nullable List<TextMergeChange> affected, @NotNull Runnable task2) {
            return this.executeMergeCommand(commandName, false, affected, task2);
        }

        public void markChangeResolved(@NotNull TextMergeChange change) {
            if (change.isResolved()) {
                return;
            }
            change.setResolved(Side.LEFT, true);
            change.setResolved(Side.RIGHT, true);
            this.onChangeResolved(change);
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void markChangeResolved(@NotNull TextMergeChange change, @NotNull Side side) {
            if (change.isResolved(side)) {
                return;
            }
            change.setResolved(side, true);
            if (change.isResolved()) {
                this.onChangeResolved(change);
            }
            this.myModel.invalidateHighlighters(change.getIndex());
        }

        public void ignoreChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (!change.isConflict() || resolveChange) {
                this.markChangeResolved(change);
            } else {
                this.markChangeResolved(change, side);
            }
        }

        public void replaceChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
            if (change.isResolved(side)) {
                return;
            }
            if (!change.isChange(side)) {
                this.markChangeResolved(change);
                return;
            }
            ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            Document sourceDocument = this.getContent(sourceSide).getDocument();
            int sourceStartLine = change.getStartLine(sourceSide);
            int sourceEndLine = change.getEndLine(sourceSide);
            List<String> newContent = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
            if (change.isConflict()) {
                boolean append = change.isOnesideAppliedConflict();
                if (append) {
                    this.myModel.appendChange(change.getIndex(), newContent);
                } else {
                    this.myModel.replaceChange(change.getIndex(), newContent);
                }
                if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                    this.markChangeResolved(change);
                } else {
                    change.markOnesideAppliedConflict();
                    this.markChangeResolved(change, side);
                }
            } else {
                this.myModel.replaceChange(change.getIndex(), newContent);
                this.markChangeResolved(change);
            }
        }

        private boolean hasNonConflictedChanges(@NotNull ThreeSide side) {
            return ContainerUtil.exists(this.getAllChanges(), change -> !change.isConflict() && this.canResolveChangeAutomatically((TextMergeChange)change, side));
        }

        private void applyNonConflictedChanges(@NotNull ThreeSide side) {
            this.executeMergeCommand("Apply Non Conflicted Changes", true, null, () -> {
                ArrayList allChanges = ContainerUtil.newArrayList(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    if (change.isConflict()) continue;
                    this.resolveChangeAutomatically(change, side);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        private boolean hasResolvableConflictedChanges() {
            return ContainerUtil.exists(this.getAllChanges(), change -> this.canResolveChangeAutomatically((TextMergeChange)change, ThreeSide.BASE));
        }

        private void applyResolvableConflictedChanges() {
            this.executeMergeCommand("Resolve Simple Conflicted Changes", true, null, () -> {
                ArrayList allChanges = ContainerUtil.newArrayList(this.getAllChanges());
                for (TextMergeChange change : allChanges) {
                    this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            });
            TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
            if (firstUnresolved != null) {
                this.doScrollToChange(firstUnresolved, true);
            }
        }

        public boolean canResolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (change.isConflict()) {
                return side == ThreeSide.BASE && change.getType().canBeResolved() && !change.isResolved(Side.LEFT) && !change.isResolved(Side.RIGHT) && !this.isChangeRangeModified(change);
            }
            return !change.isResolved() && change.isChange(side) && !this.isChangeRangeModified(change);
        }

        private boolean isChangeRangeModified(@NotNull TextMergeChange change) {
            CharSequence resultContent;
            MergeLineFragment changeFragment = change.getFragment();
            int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
            int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
            DocumentContent baseDiffContent = (DocumentContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
            Document baseDocument = baseDiffContent.getDocument();
            int resultStartLine = change.getStartLine();
            int resultEndLine = change.getEndLine();
            DocumentEx resultDocument = this.getEditor().getDocument();
            CharSequence baseContent = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
            return !StringUtil.equals((CharSequence)baseContent, (CharSequence)(resultContent = DiffUtil.getLinesContent(resultDocument, resultStartLine, resultEndLine)));
        }

        public void resolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
            if (!this.canResolveChangeAutomatically(change, side)) {
                return;
            }
            if (change.isConflict()) {
                List texts = ThreeSide.map(it -> DiffUtil.getLinesContent(this.getEditor((ThreeSide)it).getDocument(), change.getStartLine((ThreeSide)it), change.getEndLine((ThreeSide)it)));
                CharSequence newContent = ComparisonMergeUtil.tryResolveConflict((CharSequence)texts.get(0), (CharSequence)texts.get(1), (CharSequence)texts.get(2));
                if (newContent == null) {
                    LOG.warn(String.format("Can't resolve conflicting change:\n'%s'\n'%s'\n'%s'\n", texts.get(0), texts.get(1), texts.get(2)));
                    return;
                }
                String[] newContentLines = LineTokenizer.tokenize((CharSequence)newContent, (boolean)false);
                this.myModel.replaceChange(change.getIndex(), Arrays.asList(newContentLines));
                this.markChangeResolved(change);
            } else {
                Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
                this.replaceChange(change, masterSide, false);
            }
        }

        private class NavigateToChangeMarkerAction
        extends DumbAwareAction {
            private final boolean myGoToNext;

            protected NavigateToChangeMarkerAction(boolean goToNext) {
                this.myGoToNext = goToNext;
                ActionUtil.copyFrom((AnAction)this, (String)(this.myGoToNext ? "VcsShowNextChangeMarker" : "VcsShowPrevChangeMarker"));
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.getTextSettings().isEnableLstGutterMarkersInMerge());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object targetRange;
                if (!MyThreesideViewer.this.myLineStatusTracker.isValid()) {
                    return;
                }
                int line = MyThreesideViewer.this.getEditor().getCaretModel().getLogicalPosition().line;
                Object r = targetRange = this.myGoToNext ? MyThreesideViewer.this.myLineStatusTracker.getNextRange(line) : MyThreesideViewer.this.myLineStatusTracker.getPrevRange(line);
                if (targetRange != null) {
                    new MyLineStatusMarkerRenderer(MyThreesideViewer.this.myLineStatusTracker).scrollAndShow(MyThreesideViewer.this.getEditor(), (Range)targetRange);
                }
            }
        }

        private class MyLineStatusMarkerRenderer
        extends LineStatusMarkerPopupRenderer {
            MyLineStatusMarkerRenderer(LineStatusTrackerBase<?> tracker) {
                super(tracker);
            }

            @Override
            @Nullable
            protected MarkupEditorFilter getEditorFilter() {
                return editor -> editor == MyThreesideViewer.this.getEditor();
            }

            @Override
            protected int getFramingBorderSize() {
                return JBUI.scale((int)2);
            }

            @Override
            public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
                if (!this.myTracker.isValid()) {
                    return;
                }
                Document document = this.myTracker.getDocument();
                int line = Math.min(range2.getType() == 3 ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
                int[] startLines = new int[]{((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, ((MyThreesideViewer)MyThreesideViewer.this).transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
                for (ThreeSide side : ThreeSide.values()) {
                    DiffUtil.moveCaret(MyThreesideViewer.this.getEditor(side), side.select(startLines));
                }
                MyThreesideViewer.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.showAfterScroll(editor, range2);
            }

            @Override
            @NotNull
            protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
                ArrayList<AnAction> actions = new ArrayList<AnAction>();
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(this, editor, range2));
                actions.add((AnAction)new MyRollbackLineStatusRangeAction(editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(this, editor, range2));
                actions.add((AnAction)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(this, editor, range2, mousePosition));
                return actions;
            }

            private class MyRollbackLineStatusRangeAction
            extends LineStatusMarkerPopupRenderer.RangeMarkerAction {
                private MyRollbackLineStatusRangeAction(@NotNull Editor editor, Range range2) {
                    super(MyLineStatusMarkerRenderer.this, editor, range2, "Vcs.RollbackChangedLines");
                }

                @Override
                protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
                    return true;
                }

                @Override
                protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
                    DiffUtil.moveCaretToLineRangeIfNeeded(editor, range2.getLine1(), range2.getLine2());
                    MyLineStatusMarkerRenderer.this.myTracker.rollbackChanges(range2);
                }
            }
        }

        public class ModifierProvider
        extends KeyboardModifierListener {
            public void init() {
                this.init(MyThreesideViewer.this.myPanel, (Disposable)TextMergeViewer.this);
            }

            @Override
            public void onModifiersChanged() {
                for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                    change.updateGutterActions(false);
                }
            }
        }

        private class MyDividerPaintable
        implements DiffDividerDrawUtil.DividerPaintable {
            @NotNull
            private final Side mySide;

            MyDividerPaintable(Side side) {
                this.mySide = side;
            }

            @Override
            public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
                ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                for (TextMergeChange mergeChange : MyThreesideViewer.this.myAllMergeChanges) {
                    if (!mergeChange.isChange(this.mySide)) continue;
                    boolean isResolved = mergeChange.isResolved(this.mySide);
                    if (handler2.processResolvable(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), MyThreesideViewer.this.getEditor(), mergeChange.getDiffType(), isResolved)) continue;
                    return;
                }
            }
        }

        private class ShowDiffWithBaseAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            ShowDiffWithBaseAction(ThreeSide side) {
                this.mySide = side;
                String actionId = (String)this.mySide.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DiffContent baseContent = (DiffContent)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContents());
                String baseTitle = (String)ThreeSide.BASE.select(TextMergeViewer.this.myMergeRequest.getContentTitles());
                DiffContent otherContent = (DiffContent)this.mySide.select(MyThreesideViewer.this.myRequest.getContents());
                String otherTitle = (String)this.mySide.select(MyThreesideViewer.this.myRequest.getContentTitles());
                SimpleDiffRequest request = new SimpleDiffRequest(MyThreesideViewer.this.myRequest.getTitle(), baseContent, otherContent, baseTitle, otherTitle);
                ThreeSide currentSide = MyThreesideViewer.this.getCurrentSide();
                LogicalPosition currentPosition = DiffUtil.getCaretPosition(MyThreesideViewer.this.getCurrentEditor());
                LogicalPosition resultPosition = MyThreesideViewer.this.transferPosition(currentSide, this.mySide, currentPosition);
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
                DiffManager.getInstance().showDiff(MyThreesideViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)MyThreesideViewer.this.myPanel));
            }
        }

        public class MagicResolvedConflictsAction
        extends DumbAwareAction {
            public MagicResolvedConflictsAction() {
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.MagicResolveConflicts");
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasResolvableConflictedChanges());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                MyThreesideViewer.this.applyResolvableConflictedChanges();
            }
        }

        public class ApplyNonConflictsAction
        extends DumbAwareAction {
            @NotNull
            private final ThreeSide mySide;

            public ApplyNonConflictsAction(@NotNull ThreeSide side, String text) {
                String id = (String)side.select((Object)"Diff.ApplyNonConflicts.Left", (Object)"Diff.ApplyNonConflicts", (Object)"Diff.ApplyNonConflicts.Right");
                ActionUtil.copyFrom((AnAction)this, (String)id);
                this.mySide = side;
                this.getTemplatePresentation().setText(text);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(MyThreesideViewer.this.hasNonConflictedChanges(this.mySide));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                MyThreesideViewer.this.applyNonConflictedChanges(this.mySide);
            }

            public boolean displayTextInToolbar() {
                return true;
            }

            public boolean useSmallerFontForTextInToolbar() {
                return true;
            }
        }

        private class ResolveSelectedConflictsAction
        extends ApplySelectedChangesActionBase {
            ResolveSelectedConflictsAction(boolean shortcut) {
                super(shortcut);
                ActionUtil.copyFrom((AnAction)this, (String)"Diff.ResolveConflict");
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return "Resolve Automatically";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return MyThreesideViewer.this.canResolveChangeAutomatically(change, ThreeSide.BASE);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes2) {
                for (int i = changes2.size() - 1; i >= 0; --i) {
                    TextMergeChange change = changes2.get(i);
                    MyThreesideViewer.this.resolveChangeAutomatically(change, ThreeSide.BASE);
                }
            }
        }

        private class ResolveSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ResolveSelectedChangesAction(Side side) {
                super(false);
                this.mySide = side;
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return (String)this.mySide.select((Object)"Resolve using Left", (Object)"Resolve using Right");
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes2) {
                for (int i = changes2.size() - 1; i >= 0; --i) {
                    MyThreesideViewer.this.replaceChange(changes2.get(i), this.mySide, true);
                }
            }
        }

        private class ApplySelectedChangesAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            ApplySelectedChangesAction(Side side, boolean shortcut) {
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return side != ThreeSide.BASE ? "Accept" : this.getTemplatePresentation().getText();
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                if (side == ThreeSide.BASE) {
                    return true;
                }
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes2) {
                for (int i = changes2.size() - 1; i >= 0; --i) {
                    MyThreesideViewer.this.replaceChange(changes2.get(i), this.mySide, false);
                }
            }
        }

        private class IgnoreSelectedChangesAction
        extends ApplySelectedChangesActionBase {
            IgnoreSelectedChangesAction() {
                super(false);
                this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == ThreeSide.BASE;
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved();
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes2) {
                for (TextMergeChange change : changes2) {
                    MyThreesideViewer.this.markChangeResolved(change);
                }
            }
        }

        private class IgnoreSelectedChangesSideAction
        extends ApplySelectedChangesActionBase {
            @NotNull
            private final Side mySide;

            IgnoreSelectedChangesSideAction(Side side, boolean shortcut) {
                super(shortcut);
                this.mySide = side;
                ActionUtil.copyFrom((AnAction)this, (String)((String)this.mySide.select((Object)"Diff.IgnoreLeftSide", (Object)"Diff.IgnoreRightSide")));
            }

            @Override
            protected String getText(@NotNull ThreeSide side) {
                return "Ignore";
            }

            @Override
            protected boolean isVisible(@NotNull ThreeSide side) {
                return side == this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            }

            @Override
            protected boolean isEnabled(@NotNull TextMergeChange change) {
                return !change.isResolved(this.mySide);
            }

            @Override
            protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes2) {
                for (TextMergeChange change : changes2) {
                    MyThreesideViewer.this.ignoreChange(change, this.mySide, false);
                }
            }
        }

        private abstract class ApplySelectedChangesActionBase
        extends AnAction
        implements DumbAware {
            private final boolean myShortcut;

            ApplySelectedChangesActionBase(boolean shortcut) {
                this.myShortcut = shortcut;
            }

            public void update(@NotNull AnActionEvent e) {
                if (this.myShortcut) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                Presentation presentation = e.getPresentation();
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (side == null) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                if (!this.isVisible(side)) {
                    presentation.setEnabledAndVisible(false);
                    return;
                }
                presentation.setText(this.getText(side));
                presentation.setVisible(true);
                presentation.setEnabled(this.isSomeChangeSelected(side));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                ThreeSide side = MyThreesideViewer.this.getEditorSide(editor);
                if (editor == null || side == null) {
                    return;
                }
                List<TextMergeChange> selectedChanges = this.getSelectedChanges(side);
                if (selectedChanges.isEmpty()) {
                    return;
                }
                String title = e.getPresentation().getText() + " in merge";
                MyThreesideViewer.this.executeMergeCommand(title, selectedChanges.size() > 1, selectedChanges, () -> this.apply(side, selectedChanges));
            }

            private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines2 -> ContainerUtil.exists(MyThreesideViewer.this.getAllChanges(), change -> this.isChangeSelected((TextMergeChange)change, (BitSet)lines2, side))));
            }

            @NotNull
            private List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
                EditorEx editor = MyThreesideViewer.this.getEditor(side);
                BitSet lines2 = DiffUtil.getSelectedLines(editor);
                return ContainerUtil.filter(MyThreesideViewer.this.getChanges(), change -> this.isChangeSelected((TextMergeChange)change, lines2, side));
            }

            private boolean isChangeSelected(@NotNull TextMergeChange change, @NotNull BitSet lines2, @NotNull ThreeSide side) {
                if (!this.isEnabled(change)) {
                    return false;
                }
                int line1 = change.getStartLine(side);
                int line2 = change.getEndLine(side);
                return DiffUtil.isSelectedByLine(lines2, line1, line2);
            }

            protected abstract String getText(@NotNull ThreeSide var1);

            protected abstract boolean isVisible(@NotNull ThreeSide var1);

            protected abstract boolean isEnabled(@NotNull TextMergeChange var1);

            protected abstract void apply(@NotNull ThreeSide var1, @NotNull List<TextMergeChange> var2);
        }

        private class MyMergeModel
        extends MergeModelBase<TextMergeChange.State> {
            MyMergeModel(@NotNull Project project, Document document) {
                super(project, document);
            }

            @Override
            protected void reinstallHighlighters(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                change.reinstallHighlighters();
                MyThreesideViewer.this.myInnerDiffWorker.scheduleRediff(change);
            }

            @Override
            @NotNull
            protected TextMergeChange.State storeChangeState(int index) {
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                return change.storeState();
            }

            @Override
            protected void restoreChangeState(@NotNull TextMergeChange.State state) {
                super.restoreChangeState(state);
                TextMergeChange change = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(state.myIndex);
                boolean wasResolved = change.isResolved();
                change.restoreState(state);
                if (wasResolved != change.isResolved()) {
                    MyThreesideViewer.this.onChangeResolved(change);
                }
            }

            @Override
            @Nullable
            protected TextMergeChange.State processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
                TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index, oldLine1, oldLine2, shift);
                TextMergeChange mergeChange = (TextMergeChange)MyThreesideViewer.this.myAllMergeChanges.get(index);
                if (mergeChange.getStartLine() == mergeChange.getEndLine() && mergeChange.getDiffType() == TextDiffType.DELETED && !mergeChange.isResolved()) {
                    TextMergeViewer.this.myViewer.markChangeResolved(mergeChange);
                }
                return state;
            }
        }

        private class MyInnerDiffWorker {
            @NotNull
            private final Set<TextMergeChange> myScheduled = ContainerUtil.newHashSet();
            @NotNull
            private final Alarm myAlarm = new Alarm((Disposable)MyThreesideViewer.this);
            @Nullable
            private ProgressIndicator myProgress;
            private boolean myEnabled = false;

            private MyInnerDiffWorker() {
            }

            public void scheduleRediff(@NotNull TextMergeChange change) {
                this.scheduleRediff(Collections.singletonList(change));
            }

            public void scheduleRediff(@NotNull Collection<TextMergeChange> changes2) {
                if (!this.myEnabled) {
                    return;
                }
                this.putChanges(changes2);
                this.schedule();
            }

            public void onSettingsChanged() {
                boolean enabled;
                boolean bl = enabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                if (this.myEnabled == enabled) {
                    return;
                }
                this.myEnabled = enabled;
                this.rebuildEverything();
            }

            public void onEverythingChanged() {
                this.myEnabled = MyThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
                this.rebuildEverything();
            }

            public void disable() {
                this.myEnabled = false;
                this.stop();
            }

            private void rebuildEverything() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                if (this.myEnabled) {
                    this.putChanges(MyThreesideViewer.this.myAllMergeChanges);
                    this.launchRediff(true);
                } else {
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    this.myScheduled.clear();
                    for (TextMergeChange change : MyThreesideViewer.this.myAllMergeChanges) {
                        change.setInnerFragments(null);
                    }
                }
            }

            public void stop() {
                if (this.myProgress != null) {
                    this.myProgress.cancel();
                }
                this.myProgress = null;
                this.myScheduled.clear();
                this.myAlarm.cancelAllRequests();
            }

            private void putChanges(@NotNull Collection<TextMergeChange> changes2) {
                for (TextMergeChange change : changes2) {
                    if (change.isResolved()) continue;
                    this.myScheduled.add(change);
                }
            }

            private void schedule() {
                if (this.myProgress != null) {
                    return;
                }
                if (this.myScheduled.isEmpty()) {
                    return;
                }
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.launchRediff(false), 300);
            }

            private void launchRediff(boolean trySync) {
                MyThreesideViewer.this.myStatusPanel.setBusy(true);
                ArrayList scheduled = ContainerUtil.newArrayList(this.myScheduled);
                this.myScheduled.clear();
                List documents = ThreeSide.map(side -> MyThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
                List data = ContainerUtil.map((Collection)scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
                int waitMillis = trySync ? 300 : 0;
                ProgressIndicator progress = BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> this.performRediff(scheduled, data, (ProgressIndicator)indicator)), null, waitMillis, false);
                if (progress.isRunning()) {
                    this.myProgress = progress;
                }
            }

            @NotNull
            private Runnable performRediff(@NotNull List<TextMergeChange> scheduled, @NotNull List<InnerChunkData> data, @NotNull ProgressIndicator indicator) {
                ComparisonPolicy comparisonPolicy = MyThreesideViewer.this.myTextDiffProvider.getIgnorePolicy().getComparisonPolicy();
                ArrayList<MergeInnerDifferences> result2 = new ArrayList<MergeInnerDifferences>(data.size());
                for (InnerChunkData chunkData : data) {
                    result2.add(DiffUtil.compareThreesideInner(chunkData.text, comparisonPolicy, indicator));
                }
                return () -> {
                    if (!this.myEnabled || indicator.isCanceled()) {
                        return;
                    }
                    this.myProgress = null;
                    for (int i = 0; i < scheduled.size(); ++i) {
                        TextMergeChange change = (TextMergeChange)scheduled.get(i);
                        if (this.myScheduled.contains(change)) continue;
                        change.setInnerFragments((MergeInnerDifferences)result2.get(i));
                    }
                    MyThreesideViewer.this.myStatusPanel.setBusy(false);
                    if (!this.myScheduled.isEmpty()) {
                        this.launchRediff(false);
                    }
                };
            }
        }
    }
}

