/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.BinaryMergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeRequestImpl
extends BinaryMergeRequest {
    private static final Logger LOG = Logger.getInstance(BinaryMergeRequestImpl.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileContent myFile;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<byte[]> myByteContents;
    @NotNull
    private final byte[] myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;
    @Nullable
    private final Consumer<? super MergeResult> myApplyCallback;

    public BinaryMergeRequestImpl(@Nullable Project project, @NotNull FileContent file2, @NotNull byte[] originalContent, @NotNull List<DiffContent> contents, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) {
        assert (byteContents.size() == 3);
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myFile = file2;
        this.myOriginalContent = originalContent;
        this.myByteContents = byteContents;
        this.myContents = contents;
        this.myTitle = title;
        this.myTitles = contentTitles;
        this.myApplyCallback = applyCallback;
        this.onAssigned(true);
    }

    @NotNull
    public FileContent getOutputContent() {
        return this.myFile;
    }

    @NotNull
    public List<DiffContent> getContents() {
        return this.myContents;
    }

    @NotNull
    public List<byte[]> getByteContents() {
        return this.myByteContents;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        return this.myTitles;
    }

    public void applyResult(@NotNull MergeResult result2) {
        try {
            byte[] applyContent;
            switch (result2) {
                case CANCEL: {
                    applyContent = this.myOriginalContent;
                    break;
                }
                case LEFT: {
                    applyContent = (byte[])ThreeSide.LEFT.select(this.myByteContents);
                    break;
                }
                case RIGHT: {
                    applyContent = (byte[])ThreeSide.RIGHT.select(this.myByteContents);
                    break;
                }
                case RESOLVED: {
                    applyContent = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(result2.toString());
                }
            }
            if (applyContent != null) {
                WriteCommandAction.writeCommandAction(null).run(() -> {
                    try {
                        VirtualFile file2 = this.myFile.getFile();
                        if (!DiffUtil.makeWritable(this.myProject, file2)) {
                            throw new IOException("File is read-only: " + file2.getPresentableName());
                        }
                        file2.setBinaryContent(applyContent);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        Messages.showErrorDialog((Project)this.myProject, (String)"Can't apply result", (String)CommonBundle.getErrorTitle());
                    }
                });
            }
            if (this.myApplyCallback != null) {
                this.myApplyCallback.consume((Object)result2);
            }
        }
        finally {
            this.onAssigned(false);
        }
    }

    private void onAssigned(boolean assigned) {
        this.myFile.onAssigned(assigned);
        for (DiffContent content : this.myContents) {
            content.onAssigned(assigned);
        }
    }
}

