/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName2, @Nullable String title) {
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName2) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName2;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(@NotNull DiffContext context) {
        SimpleColoredComponent label2 = new SimpleColoredComponent();
        label2.setTextAlign(0);
        label2.append("Can't show diff for unknown file type. ", new SimpleTextAttributes(0, UIUtil.getInactiveTextColor()));
        if (this.myFileName != null) {
            label2.append("Associate", SimpleTextAttributes.LINK_ATTRIBUTES, () -> {
                FileType type = FileTypeChooser.associateFileType(this.myFileName);
                if (type != null) {
                    this.onSuccess(context);
                }
            });
            LinkMouseListenerBase.installSingleTagOn(label2);
        }
        return new DiffUtil.CenteredPanel((JComponent)label2, JBUI.Borders.empty((int)5));
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void onSuccess(@NotNull DiffContext context) {
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }
}

