/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.statistics;

import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/statistics/DiffUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "isUnifiedToolDefault", "", "settings", "Lcom/intellij/diff/impl/DiffSettingsHolder$DiffSettings;", "intellij.platform.diff.impl"})
public final class DiffUsagesCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        return "vcs.diff";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        List places = CollectionsKt.listOf((Object[])new String[]{"Default", "ChangesView", "VcsLogView", "CommitDialog", "Merge", "TestsFiledAssertions"});
        for (String place : places) {
            DiffSettingsHolder.DiffSettings diffSettings = DiffSettingsHolder.DiffSettings.Companion.getSettings(place);
            TextDiffSettingsHolder.TextDiffSettings textSettings = TextDiffSettingsHolder.TextDiffSettings.Companion.getSettings(place);
            usages.add(StatisticsUtilKt.getEnumUsage("ignore.policy." + place, textSettings.getIgnorePolicy()));
            usages.add(StatisticsUtilKt.getEnumUsage("highlight.policy." + place, textSettings.getHighlightPolicy()));
            usages.add(StatisticsUtilKt.getEnumUsage("show.warnings.policy." + place, textSettings.getHighlightingLevel()));
            usages.add(StatisticsUtilKt.getBooleanUsage("collapse.unchanged." + place, !textSettings.isExpandByDefault()));
            usages.add(StatisticsUtilKt.getBooleanUsage("show.line.numbers." + place, textSettings.isShowLineNumbers()));
            usages.add(StatisticsUtilKt.getBooleanUsage("use.soft.wraps." + place, textSettings.isUseSoftWraps()));
            usages.add(StatisticsUtilKt.getBooleanUsage("use.unified.diff." + place, this.isUnifiedToolDefault(diffSettings)));
            if (!Intrinsics.areEqual((Object)place, (Object)"CommitDialog")) continue;
            usages.add(StatisticsUtilKt.getBooleanUsage("enable.read.lock." + place, textSettings.isReadOnlyLock()));
        }
        DiffSettingsHolder.DiffSettings diffSettings = DiffSettingsHolder.DiffSettings.Companion.getSettings(null);
        usages.add(StatisticsUtilKt.getBooleanUsage("iterate.next.file", diffSettings.isGoToNextFileOnNextDifference()));
        ExternalDiffSettings externalSettings = ExternalDiffSettings.getInstance();
        usages.add(StatisticsUtilKt.getBooleanUsage("external.diff", externalSettings.isDiffEnabled()));
        usages.add(StatisticsUtilKt.getBooleanUsage("external.diff.default", externalSettings.isDiffEnabled() && externalSettings.isDiffDefault()));
        usages.add(StatisticsUtilKt.getBooleanUsage("external.merge", externalSettings.isMergeEnabled()));
        return usages;
    }

    private final boolean isUnifiedToolDefault(DiffSettingsHolder.DiffSettings settings) {
        List<String> toolOrder = settings.getDiffToolsOrder();
        int defaultToolIndex = toolOrder.indexOf(SimpleDiffTool.class.getCanonicalName());
        int unifiedToolIndex = toolOrder.indexOf(UnifiedDiffTool.class.getCanonicalName());
        if (unifiedToolIndex == -1) {
            return false;
        }
        return defaultToolIndex == -1 || unifiedToolIndex < defaultToolIndex;
    }
}

