/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();
    private static final Logger LOG = Logger.getInstance(ErrorDiffTool.class);

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return new MyViewer(context, request);
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return true;
    }

    @NotNull
    public String getName() {
        return "Error viewer";
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JPanel myPanel;

        MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
            this.myContext = context;
            this.myRequest = request;
            this.myPanel = JBUI.Panels.simplePanel((Component)this.createComponent(request));
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request) {
            if (request instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request).getMessage();
                return DiffUtil.createMessagePanel(message);
            }
            if (request instanceof ComponentDiffRequest) {
                return ((ComponentDiffRequest)request).getComponent(this.myContext);
            }
            if (request instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request).getContents();
                for (DiffContent content : contents) {
                    if (!(content instanceof FileContent) || !FileTypes.UNKNOWN.equals(content.getContentType())) continue;
                    VirtualFile file2 = ((FileContent)content).getFile();
                    UnknownFileTypeDiffRequest unknownFileTypeRequest = new UnknownFileTypeDiffRequest(file2, this.myRequest.getTitle());
                    return unknownFileTypeRequest.getComponent(this.myContext);
                }
            }
            LOG.info("Can't show diff for " + request.getClass().getName());
            if (request instanceof ContentDiffRequest) {
                for (DiffContent content : ((ContentDiffRequest)request).getContents()) {
                    String type = content.getContentType() != null ? content.getContentType().getName() : "null";
                    LOG.info(String.format("      %s, content type: %s", content.getClass().getName(), type));
                }
            }
            return DiffUtil.createMessagePanel("Can't show diff");
        }

        @NotNull
        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            String fileName2;
            if (this.myRequest instanceof UnknownFileTypeDiffRequest && (fileName2 = ((UnknownFileTypeDiffRequest)this.myRequest).getFileName()) != null && FileTypeManager.getInstance().getFileTypeByFileName(fileName2) != UnknownFileType.INSTANCE && this.myContext instanceof DiffContextEx) {
                ApplicationManager.getApplication().invokeLater(() -> ((DiffContextEx)this.myContext).reloadDiffRequest(), ModalityState.current());
            }
            return new FrameDiffTool.ToolbarComponents();
        }

        public void dispose() {
        }
    }
}

