/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideBinaryDiffViewer
extends TwosideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;
    @NotNull
    private final StatusPanel myStatusPanel = new StatusPanel();

    public TwosideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        new MyFocusOppositePaneAction().install(this.myPanel);
        this.myContentPanel.setTopAction((AnAction)new MyAcceptSideAction(Side.LEFT));
        this.myContentPanel.setBottomAction((AnAction)new MyAcceptSideAction(Side.RIGHT));
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyAcceptSideAction(Side.LEFT));
        group.add((AnAction)new MyAcceptSideAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        try {
            indicator.checkCanceled();
            List contents = this.myRequest.getContents();
            if (!(contents.get(0) instanceof FileContent) || !(contents.get(1) instanceof FileContent)) {
                return this.applyNotification(null);
            }
            VirtualFile file1 = ((FileContent)contents.get(0)).getFile();
            VirtualFile file2 = ((FileContent)contents.get(1)).getFile();
            JComponent notification = (JComponent)ReadAction.compute(() -> {
                if (!file1.isValid() || !file2.isValid()) {
                    return DiffNotifications.createError();
                }
                if (FileUtilRt.isTooLarge((long)file1.getLength()) || FileUtilRt.isTooLarge((long)file2.getLength())) {
                    return DiffNotifications.createNotification("Files are too large to compare");
                }
                try {
                    byte[] bytes1 = file1.contentsToByteArray();
                    byte[] bytes2 = file2.contentsToByteArray();
                    return Arrays.equals(bytes1, bytes2) ? DiffNotifications.createEqualContents() : null;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            });
            return this.applyNotification(notification);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(DiffNotifications.createError());
        }
    }

    @NotNull
    private Runnable applyNotification(@Nullable JComponent notification) {
        return () -> {
            this.clearDiffPresentation();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getCurrentEditor() {
        return ((BinaryEditorHolder)this.getCurrentEditorHolder()).getEditor();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        return this.myStatusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return TwosideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            TwosideBinaryDiffViewer.this.setCurrentSide(TwosideBinaryDiffViewer.this.getCurrentSide().other());
            DiffUtil.requestFocus(TwosideBinaryDiffViewer.this.getProject(), TwosideBinaryDiffViewer.this.getPreferredFocusedComponent());
        }
    }

    private class MyAcceptSideAction
    extends DumbAwareAction {
        @NotNull
        private final Side myBaseSide;

        MyAcceptSideAction(Side baseSide) {
            this.myBaseSide = baseSide;
            this.getTemplatePresentation().setText("Copy Content to " + (String)baseSide.select((Object)"Right", (Object)"Left"));
            this.getTemplatePresentation().setIcon((Icon)baseSide.select((Object)AllIcons.Vcs.Arrow_right, (Object)AllIcons.Vcs.Arrow_left));
            this.setShortcutSet(ActionManager.getInstance().getAction((String)baseSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
        }

        public void update(@NotNull AnActionEvent e) {
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            boolean enabled = baseFile != null && targetFile != null && targetFile.isWritable();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile baseFile = this.getContentFile(this.myBaseSide);
            VirtualFile targetFile = this.getContentFile(this.myBaseSide.other());
            assert (baseFile != null && targetFile != null);
            try {
                WriteAction.run(() -> targetFile.setBinaryContent(baseFile.contentsToByteArray()));
            }
            catch (IOException err) {
                LOG.warn((Throwable)err);
                Messages.showErrorDialog((Project)TwosideBinaryDiffViewer.this.getProject(), (String)err.getMessage(), (String)"Can't Copy File");
            }
        }

        @Nullable
        private VirtualFile getContentFile(@NotNull Side side) {
            DiffContent content = (DiffContent)side.select(TwosideBinaryDiffViewer.this.myRequest.getContents());
            VirtualFile file2 = content instanceof FileContent ? ((FileContent)content).getFile() : null;
            return file2 != null && file2.isValid() ? file2 : null;
        }
    }
}

