/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.dir;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.DataManager;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.JarFileDiffElement;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirDiffViewer
implements FrameDiffTool.DiffViewer {
    private final DirDiffPanel myDirDiffPanel;
    private final JPanel myPanel;
    private final String myHelpID;

    DirDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        this(context, DirDiffViewer.createDiffElement((DiffContent)request.getContents().get(0)), DirDiffViewer.createDiffElement((DiffContent)request.getContents().get(1)), (DirDiffSettings)ObjectUtils.notNull((Object)context.getUserData(DirDiffSettings.KEY), (Object)new DirDiffSettings()), "reference.dialogs.diff.folder");
    }

    DirDiffViewer(final @NotNull DiffContext context, @NotNull DiffElement element1, @NotNull DiffElement element2, @NotNull DirDiffSettings settings, @Nullable String helpID) {
        this.myHelpID = helpID;
        DirDiffTableModel model = new DirDiffTableModel(context.getProject(), element1, element2, settings);
        this.myDirDiffPanel = new DirDiffPanel(model, new DirDiffWindow(){

            @Override
            @NotNull
            public Disposable getDisposable() {
                return DirDiffViewer.this;
            }

            @Override
            public void setTitle(@NotNull String title) {
                if (context instanceof DiffContextEx) {
                    ((DiffContextEx)context).setWindowTitle(title);
                }
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myDirDiffPanel.getPanel(), "Center");
        DataManager.registerDataProvider((JComponent)this.myPanel, dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return this.myHelpID;
            }
            return this.myDirDiffPanel.getData(dataId);
        });
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.myDirDiffPanel.setupSplitter();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = Arrays.asList(this.myDirDiffPanel.getActions());
        components.statusPanel = this.myDirDiffPanel.extractFilterPanel();
        return components;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDirDiffPanel);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDirDiffPanel.getTable();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(0))) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(1))) {
            return false;
        }
        return !(contents.get(0) instanceof EmptyContent) || !(contents.get(1) instanceof EmptyContent);
    }

    private static boolean canShowContent(@NotNull DiffContent content) {
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return true;
        }
        return content instanceof FileContent && content.getContentType() instanceof ArchiveFileType && ((FileContent)content).getFile().isValid() && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    @NotNull
    private static DiffElement createDiffElement(@NotNull DiffContent content) {
        if (content instanceof EmptyContent) {
            return new DiffElement(){

                public String getPath() {
                    return "";
                }

                @NotNull
                public String getName() {
                    return "Nothing";
                }

                public long getSize() {
                    return -1L;
                }

                public long getTimeStamp() {
                    return -1L;
                }

                public boolean isContainer() {
                    return true;
                }

                public DiffElement[] getChildren() {
                    return EMPTY_ARRAY;
                }

                public byte[] getContent() {
                    return null;
                }

                public Object getValue() {
                    return null;
                }
            };
        }
        if (content instanceof DirectoryContent) {
            return new VirtualFileDiffElement(((DirectoryContent)content).getFile());
        }
        if (content instanceof FileContent && content.getContentType() instanceof ArchiveFileType) {
            return new JarFileDiffElement(((FileContent)content).getFile());
        }
        throw new IllegalArgumentException(content.getClass() + " " + content.getContentType());
    }
}

