/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        try {
            List<DiffRequest> requests = ExternalDiffTool.loadRequestsUnderProgress(project, chain);
            if (requests == null) {
                return;
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request : requests) {
                if (ExternalDiffTool.canShow(request)) {
                    ExternalDiffTool.showRequest(project, request);
                    continue;
                }
                showInBuiltin.add(request);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints);
            }
        }
        catch (ProcessCanceledException requests) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Can't Show Diff In External Tool");
        }
    }

    @Nullable
    private static List<DiffRequest> loadRequestsUnderProgress(@Nullable Project project, @NotNull DiffRequestChain chain) throws Throwable {
        if (chain instanceof AsyncDiffRequestChain) {
            return (List)ExternalDiffTool.loadInBackground(project, "Loading Requests", indicator -> {
                ListSelection<? extends DiffRequestProducer> listSelection = ((AsyncDiffRequestChain)chain).loadRequestsInBackground();
                return ExternalDiffTool.collectRequests(project, listSelection.getList(), listSelection.getSelectedIndex(), indicator);
            });
        }
        List allProducers = chain.getRequests();
        int index = chain.getIndex();
        return (List)ExternalDiffTool.loadInBackground(project, "Loading Requests", indicator -> ExternalDiffTool.collectRequests(project, allProducers, index, indicator));
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> allProducers, int index, @NotNull ProgressIndicator indicator) {
        if (allProducers.isEmpty()) {
            return Collections.emptyList();
        }
        List<DiffRequestProducer> producers = Collections.singletonList(allProducers.get(index));
        return ExternalDiffTool.collectRequests(project, producers, indicator);
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> producers, @NotNull ProgressIndicator indicator) {
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                requests.add(diffRequestProducer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(diffRequestProducer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("Diff", "Can't Load Some Changes", StringUtil.join(errorRequests, (String)"<br>"), NotificationType.ERROR).notify(project);
        }
        return requests;
    }

    public static void showRequest(@Nullable Project project, @NotNull DiffRequest request) throws ExecutionException, IOException {
        request.onAssigned(true);
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        List contents = ((ContentDiffRequest)request).getContents();
        List titles = ((ContentDiffRequest)request).getContentTitles();
        ExternalDiffToolUtil.execute(project, settings, contents, titles, request.getTitle());
        request.onAssigned(false);
    }

    public static boolean canShow(@NotNull DiffRequest request) {
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static <T> T loadInBackground(@Nullable Project project, @NotNull String title, final @NotNull ThrowableConvertor<ProgressIndicator, T, Throwable> computable) throws Throwable {
        final Ref requestsRef = new Ref();
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    requestsRef.set(computable.convert((Object)indicator));
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        });
        if (!exceptionRef.isNull()) {
            throw (Throwable)exceptionRef.get();
        }
        return (T)requestsRef.get();
    }
}

