/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffChange {
    @NotNull
    private final UnifiedDiffViewer myViewer;
    @NotNull
    private final EditorEx myEditor;
    private int myLine1;
    private int myLine2;
    @NotNull
    private final LineFragment myLineFragment;
    @NotNull
    private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    private final List<MyGutterOperation> myOperations = new ArrayList<MyGutterOperation>();

    public UnifiedDiffChange(@NotNull UnifiedDiffViewer viewer, @NotNull ChangedBlock block) {
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myLine1 = block.getLine1();
        this.myLine2 = block.getLine2();
        this.myLineFragment = block.getLineFragment();
        LineRange deleted = block.getRange1();
        LineRange inserted = block.getRange2();
        this.installHighlighter(deleted, inserted);
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void installHighlighter(@NotNull LineRange deleted, @NotNull LineRange inserted) {
        assert (this.myHighlighters.isEmpty());
        this.doInstallHighlighters(deleted, inserted);
        this.doInstallActionHighlighters();
    }

    private void doInstallActionHighlighters() {
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (leftEditable && rightEditable) {
            this.myOperations.add(this.createOperation(Side.LEFT));
            this.myOperations.add(this.createOperation(Side.RIGHT));
        } else if (rightEditable) {
            this.myOperations.add(this.createOperation(Side.LEFT));
        }
    }

    private void doInstallHighlighters(@NotNull LineRange deleted, @NotNull LineRange inserted) {
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, deleted, inserted, this.myLineFragment.getInnerFragments()));
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        return this.myLineFragment;
    }

    public void processChange(int oldLine1, int oldLine2, int shift) {
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(this.myLine1, this.myLine2, oldLine1, oldLine2, shift);
        this.myLine1 = newRange.startLine;
        this.myLine2 = newRange.endLine;
    }

    public void updateGutterActions() {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update();
        }
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side sourceSide) {
        int offset = this.myEditor.getDocument().getLineStartOffset(this.myLine1);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(sourceSide, highlighter);
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon) {
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (UnifiedDiffChange.this.myViewer.isStateIsOutOfDate()) {
                    return;
                }
                if (!UnifiedDiffChange.this.myViewer.isEditable(sourceSide.other(), true)) {
                    return;
                }
                Project project = UnifiedDiffChange.this.myViewer.getProject();
                Document document = UnifiedDiffChange.this.myViewer.getDocument(sourceSide.other());
                DiffUtil.executeWriteCommand(document, project, "Replace change", () -> {
                    UnifiedDiffChange.this.myViewer.replaceChange(UnifiedDiffChange.this, sourceSide);
                    UnifiedDiffChange.this.myViewer.scheduleRediff();
                });
                UnifiedDiffChange.this.myViewer.rediff();
            }
        };
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;

        private MyGutterOperation(@NotNull Side sourceSide, RangeHighlighter highlighter) {
            this.mySide = sourceSide;
            this.myHighlighter = highlighter;
            this.update();
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update() {
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            if (UnifiedDiffChange.this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!UnifiedDiffChange.this.myViewer.isEditable(this.mySide.other(), true)) {
                return null;
            }
            if (this.mySide.isLeft()) {
                return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Revert", AllIcons.Diff.Remove);
            }
            return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Accept", AllIcons.Actions.Checked);
        }
    }
}

