/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedContentPanel;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntFunction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final UnifiedDiffPanel myPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper = new MyInitialScrollHelper();
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final TwosideTextDiffProvider.NoIgnore myTextDiffProvider;
    @NotNull
    protected Side myMasterSide = Side.RIGHT;
    @Nullable
    private ChangedBlockData myChangedBlockData;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet = false;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        super(context, (ContentDiffRequest)request);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.myEditor, this.myEditor}));
        UnifiedContentPanel contentPanel = new UnifiedContentPanel(titles, this.myEditor);
        this.myPanel = new UnifiedDiffPanel(this.myProject, contentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        this.myTextDiffProvider = DiffUtil.createNoIgnoreTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    protected void updateEditorCanBeTyped() {
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        return group;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (this.isEditable(Side.RIGHT, false)) {
            group.add(new ReplaceSelectedChangesAction(Side.LEFT, false));
            group.add(new ReplaceSelectedChangesAction(Side.RIGHT, false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        return group;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        try {
            indicator.checkCanceled();
            Document document1 = this.getContent1().getDocument();
            Document document2 = this.getContent2().getDocument();
            CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
            List<LineFragment> fragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
            DocumentContent content1 = this.getContent1();
            DocumentContent content2 = this.getContent2();
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ReadAction.compute(() -> {
                indicator.checkCanceled();
                UnifiedFragmentBuilder builder2 = new UnifiedFragmentBuilder(fragments, document1, document2, this.myMasterSide);
                builder2.exec();
                indicator.checkCanceled();
                EditorHighlighter highlighter = this.buildHighlighter(this.myProject, content1, content2, texts[0], texts[1], builder2.getRanges(), builder2.getText().length());
                UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(this.myProject, document1, document2, builder2.getRanges());
                return new TwosideDocumentData(builder2, highlighter, rangeHighlighter);
            });
            UnifiedFragmentBuilder builder2 = data.getBuilder();
            LineNumberConvertor convertor1 = builder2.getConvertor1();
            LineNumberConvertor convertor2 = builder2.getConvertor2();
            List<LineRange> changedLines = builder2.getChangedLines();
            boolean isContentsEqual = builder2.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder2.getText(), data.getHighlighter(), data.getRangeHighlighter(), convertor1.createConvertor(), convertor2.createConvertor());
            return this.apply(editorData, builder2.getBlocks(), convertor1, convertor2, changedLines, isContentsEqual);
        }
        catch (DiffTooBigException e) {
            return () -> {
                this.clearDiffPresentation();
                this.myPanel.setTooBigContent();
            };
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return () -> {
                this.clearDiffPresentation();
                this.myPanel.setErrorContent();
            };
        }
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    protected void markSuppressEditorTyping() {
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    protected void markStateIsOutOfDate() {
        this.myStateIsOutOfDate = true;
        if (this.myChangedBlockData != null) {
            for (UnifiedDiffChange diffChange : this.myChangedBlockData.getDiffChanges()) {
                diffChange.updateGutterActions();
            }
        }
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    private Runnable apply(@NotNull CombinedEditorData data, @NotNull List<ChangedBlock> blocks, @NotNull LineNumberConvertor convertor1, @NotNull LineNumberConvertor convertor2, @NotNull List<LineRange> changedLines, boolean isContentsEqual) {
        return () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            LineCol oldCaretPosition = LineCol.fromOffset((Document)this.myDocument, (int)this.myEditor.getCaretModel().getPrimaryCaret().getOffset());
            Pair<int[], Side> oldCaretLineTwoside = this.transferLineFromOneside(oldCaretPosition.line);
            this.clearDiffPresentation();
            if (isContentsEqual) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            TIntFunction foldingLineConvertor = this.myFoldingModel.getLineNumberConvertor();
            TIntFunction contentConvertor1 = DiffUtil.getContentLineConvertor(this.getContent1());
            TIntFunction contentConvertor2 = DiffUtil.getContentLineConvertor(this.getContent2());
            this.myEditor.getGutterComponentEx().setLineNumberConvertor(UnifiedDiffViewer.mergeLineConverters(contentConvertor1, data.getLineConvertor1(), foldingLineConvertor), UnifiedDiffViewer.mergeLineConverters(contentConvertor2, data.getLineConvertor2(), foldingLineConvertor));
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myDuringOnesideDocumentModification = true;
                try {
                    this.myDocument.setText(data.getText());
                }
                finally {
                    this.myDuringOnesideDocumentModification = false;
                }
            });
            if (data.getHighlighter() != null) {
                this.myEditor.setHighlighter(data.getHighlighter());
            }
            DiffUtil.setEditorCodeStyle(this.myProject, this.myEditor, this.getContent(this.myMasterSide));
            if (data.getRangeHighlighter() != null) {
                data.getRangeHighlighter().apply(this.myProject, this.myDocument);
            }
            ArrayList<UnifiedDiffChange> diffChanges = new ArrayList<UnifiedDiffChange>(blocks.size());
            for (Object block : blocks) {
                diffChanges.add(new UnifiedDiffChange(this, (ChangedBlock)block));
            }
            ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
            if (!this.myEditor.isViewer()) {
                for (ChangedBlock block : blocks) {
                    LineRange range2 = (LineRange)this.myMasterSide.select((Object)block.getRange2(), (Object)block.getRange1());
                    if (range2.isEmpty()) continue;
                    TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range2.start, range2.end);
                    guarderRangeBlocks.add(this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                }
                int textLength = this.myDocument.getTextLength();
                guarderRangeBlocks.add(this.createGuardedBlock(textLength, textLength));
            }
            this.myChangedBlockData = new ChangedBlockData(diffChanges, guarderRangeBlocks, convertor1, convertor2, isContentsEqual);
            int newCaretLine = this.transferLineToOneside((Side)oldCaretLineTwoside.second, ((Side)oldCaretLineTwoside.second).select((int[])oldCaretLineTwoside.first));
            this.myEditor.getCaretModel().moveToOffset(LineCol.toOffset((Document)this.myDocument, (int)newCaretLine, (int)oldCaretPosition.column));
            this.myFoldingModel.install(changedLines, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myStatusPanel.update();
            this.myPanel.setGoodContent();
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        };
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start2, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start2, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        return block;
    }

    private static TIntFunction mergeLineConverters(@Nullable TIntFunction contentConvertor, @NotNull TIntFunction unifiedConvertor, @NotNull TIntFunction foldingConvertor) {
        return DiffUtil.mergeLineConverters(DiffUtil.mergeLineConverters(contentConvertor, unifiedConvertor), foldingConvertor);
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertInv(line);
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return -1;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convert(line);
    }

    public int transferLineToOneside(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return line;
        }
        return this.myChangedBlockData.getLineNumberConvertor(side).convertApproximateInv(line);
    }

    @NotNull
    public Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines2 = new int[2];
        if (this.myChangedBlockData == null) {
            lines2[0] = line;
            lines2[1] = line;
            return Pair.create((Object)lines2, (Object)this.myMasterSide);
        }
        LineNumberConvertor lineConvertor1 = this.myChangedBlockData.getLineNumberConvertor(Side.LEFT);
        LineNumberConvertor lineConvertor2 = this.myChangedBlockData.getLineNumberConvertor(Side.RIGHT);
        Side side = this.myMasterSide;
        lines2[0] = lineConvertor1.convert(line);
        lines2[1] = lineConvertor2.convert(line);
        if (lines2[0] == -1 && lines2[1] == -1) {
            lines2[0] = lineConvertor1.convertApproximate(line);
            lines2[1] = lineConvertor2.convertApproximate(line);
        } else if (lines2[0] == -1) {
            lines2[0] = lineConvertor1.convertApproximate(line);
            side = Side.RIGHT;
        } else if (lines2[1] == -1) {
            lines2[1] = lineConvertor2.convertApproximate(line);
            side = Side.LEFT;
        }
        return Pair.create((Object)lines2, (Object)side);
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        for (RangeMarker block : this.myChangedBlockData.getGuardedRangeBlocks()) {
            this.myDocument.removeGuardedBlock(block);
        }
        this.myChangedBlockData = null;
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.scheduleRediff();
    }

    public void replaceChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    public void appendChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffViewerUtil.getTextSettings(this.myContext);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        return TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
    }

    @NotNull
    public Side getMasterSide() {
        return this.myMasterSide;
    }

    @NotNull
    public EditorEx getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected List<? extends EditorEx> getEditors() {
        return Collections.singletonList(this.myEditor);
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        return this.myRequest.getContents();
    }

    @NotNull
    protected DocumentContent getContent(@NotNull Side side) {
        return (DocumentContent)side.select(this.getContents());
    }

    @NotNull
    protected DocumentContent getContent1() {
        return this.getContent(Side.LEFT);
    }

    @NotNull
    protected DocumentContent getContent2() {
        return this.getContent(Side.RIGHT);
    }

    @Nullable
    protected List<UnifiedDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        return this.myStatusPanel;
    }

    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument(side));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        return this.getContent(side).getDocument();
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getNavigatable(LineCol.fromCaret((Editor)this.myEditor));
    }

    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        if (this.myChangedBlockData == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @Nullable
    protected Navigatable getNavigatable(@NotNull LineCol position) {
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int line1 = ((int[])pair.first)[0];
        int line2 = ((int[])pair.first)[1];
        Navigatable navigatable1 = this.getContent1().getNavigatable(new LineCol(line1, position.column));
        Navigatable navigatable2 = this.getContent2().getNavigatable(new LineCol(line2, position.column));
        if (navigatable1 == null) {
            return navigatable2;
        }
        if (navigatable2 == null) {
            return navigatable1;
        }
        return (Navigatable)((Side)pair.second).select((Object)navigatable1, (Object)navigatable2);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        UnifiedDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            super(new EditorEx[]{editor}, disposable);
        }

        /*
         * Exception decompiling
         */
        public void install(@Nullable List<LineRange> changedLines, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            return this.getLineConvertor(0);
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return UnifiedDiffViewer.this.getEditors();
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                return new LogicalPosition(0, 0);
            }
            return new LogicalPosition(line, column);
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes2 = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            UnifiedDiffChange targetChange = scrollToChangePolicy.select(changes2);
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges());
            int line = this.myNavigationContext.contextMatchCheck((Iterator)changedLinesIterator);
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(UnifiedDiffViewer.this.getContent2().getDocument());
                line = this.myNavigationContext.contextMatchCheck((Iterator)allLinesIterator);
            }
            if (line == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
            return true;
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @NotNull
        private final TIntFunction myLineConvertor2;

        CombinedEditorData(@NotNull CharSequence text, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter, @NotNull TIntFunction convertor1, @NotNull TIntFunction convertor2) {
            this.myText = text;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            return this.myText;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            return this.myLineConvertor1;
        }

        @NotNull
        public TIntFunction getLineConvertor2() {
            return this.myLineConvertor2;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final List<RangeMarker> myGuardedRangeBlocks;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor1;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor2;
        private final boolean myIsContentsEqual;

        ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull List<RangeMarker> guarderRangeBlocks, @NotNull LineNumberConvertor lineNumberConvertor1, @NotNull LineNumberConvertor lineNumberConvertor2, boolean isContentsEqual) {
            this.myDiffChanges = diffChanges;
            this.myGuardedRangeBlocks = guarderRangeBlocks;
            this.myLineNumberConvertor1 = lineNumberConvertor1;
            this.myLineNumberConvertor2 = lineNumberConvertor2;
            this.myIsContentsEqual = isContentsEqual;
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            return this.myDiffChanges;
        }

        @NotNull
        public List<RangeMarker> getGuardedRangeBlocks() {
            return this.myGuardedRangeBlocks;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
            return (LineNumberConvertor)side.select((Object)this.myLineNumberConvertor1, (Object)this.myLineNumberConvertor2);
        }

        public boolean isContentsEqual() {
            return this.myIsContentsEqual;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final UnifiedFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        TwosideDocumentData(@NotNull UnifiedFragmentBuilder builder2, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            this.myBuilder = builder2;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public UnifiedFragmentBuilder getBuilder() {
            return this.myBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return null;
            }
            int changesCount = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges().size();
            if (changesCount == 0 && !UnifiedDiffViewer.this.myChangedBlockData.isContentsEqual()) {
                return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{changesCount});
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final List<UnifiedDiffChange> myChanges;
        private int myIndex = 0;

        private ChangedLinesIterator(List<UnifiedDiffChange> changes2) {
            this.myChanges = changes2;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent2().getDocument();
            CharSequence insertedText = DiffUtil.getLinesContent(document, lineFragment.getStartLine2(), lineFragment.getEndLine2());
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line : tokenizer.execute()) {
                this.addLine(lineNumber, line);
                ++lineNumber;
            }
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            if (UnifiedDiffViewer.this.myChangedBlockData != null) {
                for (UnifiedDiffChange unifiedDiffChange : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    unifiedDiffChange.updateGutterActions();
                }
            }
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            UnifiedDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getNavigatable(new LineCol(line));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            return ContainerUtil.notNullize(UnifiedDiffViewer.this.getDiffChanges());
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            return UnifiedDiffViewer.this.myEditor;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            return change.getLine2();
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Append");
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes2) {
            for (UnifiedDiffChange change : changes2) {
                UnifiedDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText((String)focusedSide.select((Object)"Revert", (Object)"Accept"));
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.Remove, (Object)AllIcons.Actions.Checked));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes2) {
            for (UnifiedDiffChange change : changes2) {
                UnifiedDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;
        protected final boolean myShortcut;

        ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            this.myModifiedSide = modifiedSide;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<UnifiedDiffChange> selectedChanges = this.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title, () -> {
                this.apply(ContainerUtil.reverse((List)selectedChanges));
                UnifiedDiffViewer.this.scheduleRediff();
            });
        }

        protected boolean isSomeChangeSelected() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes2 = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            if (changes2.isEmpty()) {
                return false;
            }
            return DiffUtil.isSomeRangeSelected(UnifiedDiffViewer.this.getEditor(), (Condition<? super BitSet>)((Condition)lines2 -> ContainerUtil.exists((Iterable)changes2, change -> this.isChangeSelected((UnifiedDiffChange)change, (BitSet)lines2))));
        }

        @NotNull
        private List<UnifiedDiffChange> getSelectedChanges() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return Collections.emptyList();
            }
            BitSet lines2 = DiffUtil.getSelectedLines(UnifiedDiffViewer.this.myEditor);
            List<UnifiedDiffChange> changes2 = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            return ContainerUtil.filter(changes2, change -> this.isChangeSelected((UnifiedDiffChange)change, lines2));
        }

        private boolean isChangeSelected(@NotNull UnifiedDiffChange change, @NotNull BitSet lines2) {
            return DiffUtil.isSelectedByLine(lines2, change.getLine1(), change.getLine2());
        }

        protected abstract void apply(@NotNull List<UnifiedDiffChange> var1);
    }

    private class MyOnesideDocumentListener
    implements DocumentListener {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                LOG.warn("oneside beforeDocumentChange - myChangedBlockData == null");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor masterConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide);
                LineNumberConvertor slaveConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide.other());
                masterConvertor.handleMasterChange(line1, line2, shift, true);
                slaveConvertor.handleMasterChange(line1, line2, shift, false);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            StringBuilder info = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== UnifiedDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }
    }
}

