/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.holders;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHolder
extends EditorHolder {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Wrapper myPanel;

    public TextEditorHolder(@Nullable Project project, @NotNull EditorEx editor) {
        this.myEditor = editor;
        this.myPanel = new Wrapper(this.myEditor.getComponent());
        DataManager.registerDataProvider((JComponent)this.myPanel, dataId -> {
            Object o;
            if (project != null && !project.isDisposed() && Registry.is((String)"diff.pass.rich.editor.context") && (o = FileEditorManager.getInstance((Project)project).getData(dataId, (Editor)editor, editor.getCaretModel().getCurrentCaret())) != null) {
                return o;
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return editor;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return editor.getVirtualFile();
            }
            return null;
        });
    }

    @NotNull
    public EditorEx getEditor() {
        return this.myEditor;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public void installFocusListener(@NotNull FocusListener listener2) {
        this.myEditor.getContentComponent().addFocusListener(listener2);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    @NotNull
    public static TextEditorHolder create(@Nullable Project project, @NotNull DocumentContent content) {
        EditorEx editor = DiffUtil.createEditor(content.getDocument(), project, false, true);
        DiffUtil.configureEditor(editor, content, project);
        return new TextEditorHolder(project, editor);
    }

    public static class TextEditorHolderFactory
    extends EditorHolderFactory<TextEditorHolder> {
        public static final TextEditorHolderFactory INSTANCE = new TextEditorHolderFactory();

        @Override
        @NotNull
        public TextEditorHolder create(@NotNull DiffContent content, @NotNull DiffContext context) {
            return TextEditorHolder.create(context.getProject(), (DocumentContent)content);
        }

        @Override
        public boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            return content instanceof DocumentContent;
        }

        @Override
        public boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            return content instanceof DocumentContent;
        }
    }
}

