/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.simple.SimpleOnesideDiffViewer;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffTool
implements FrameDiffTool {
    public static final SimpleDiffTool INSTANCE = new SimpleDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (SimpleOnesideDiffViewer.canShowRequest(context, request)) {
            return new SimpleOnesideDiffViewer(context, request);
        }
        if (SimpleDiffViewer.canShowRequest(context, request)) {
            return new SimpleDiffViewer(context, request);
        }
        if (SimpleThreesideDiffViewer.canShowRequest(context, request)) {
            return new SimpleThreesideDiffViewer(context, request);
        }
        throw new IllegalArgumentException(request.toString());
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return SimpleOnesideDiffViewer.canShowRequest(context, request) || SimpleDiffViewer.canShowRequest(context, request) || SimpleThreesideDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    public String getName() {
        return "Side-by-side viewer";
    }
}

