/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.util.Side;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeDiffSplitter
extends JPanel {
    @NotNull
    private final List<? extends JComponent> myContents;
    @NotNull
    private final Divider myDivider1;
    @NotNull
    private final Divider myDivider2;
    private float myProportion1;
    private float myProportion2;

    public ThreeDiffSplitter(@NotNull List<? extends JComponent> components) {
        assert (components.size() == 3);
        this.myContents = components;
        this.myDivider1 = new Divider(Side.LEFT);
        this.myDivider2 = new Divider(Side.RIGHT);
        this.add(this.myDivider1);
        this.add(this.myDivider2);
        for (JComponent jComponent : this.myContents) {
            this.add(jComponent);
        }
        this.resetProportions();
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        this.getDivider(side).setPainter(painter);
    }

    public void repaintDividers() {
        this.repaintDivider(Side.LEFT);
        this.repaintDivider(Side.RIGHT);
    }

    public void repaintDivider(@NotNull Side side) {
        this.getDivider(side).repaint();
    }

    @NotNull
    private Divider getDivider(@NotNull Side side) {
        return (Divider)side.select((Object)this.myDivider1, (Object)this.myDivider2);
    }

    private void resetProportions() {
        this.myProportion2 = 0.33333334f;
        this.myProportion1 = 0.33333334f;
    }

    private void expandMiddlePanel() {
        this.myProportion2 = 0.0f;
        this.myProportion1 = 0.0f;
    }

    private boolean areDefaultProportions() {
        int width = this.getWidth();
        int[] widths1 = ThreeDiffSplitter.calcComponentsWidths(width, this.myProportion1, this.myProportion2);
        int[] widths2 = ThreeDiffSplitter.calcComponentsWidths(width, 0.33333334f, 0.33333334f);
        return Arrays.equals(widths1, widths2);
    }

    private void setProportion(float proportion, @NotNull Side side) {
        proportion = Math.min(1.0f, Math.max(0.0f, proportion));
        float otherProportion = ((Float)side.select((Object)Float.valueOf(this.myProportion2), (Object)Float.valueOf(this.myProportion1))).floatValue();
        otherProportion = Math.min(otherProportion, 1.0f - proportion);
        this.myProportion1 = ((Float)side.select((Object)Float.valueOf(proportion), (Object)Float.valueOf(otherProportion))).floatValue();
        this.myProportion2 = ((Float)side.select((Object)Float.valueOf(otherProportion), (Object)Float.valueOf(proportion))).floatValue();
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        JComponent[] components = new JComponent[]{this.myContents.get(0), this.myDivider1, this.myContents.get(1), this.myDivider2, this.myContents.get(2)};
        int[] contentWidths = ThreeDiffSplitter.calcComponentsWidths(width, this.myProportion1, this.myProportion2);
        int x = 0;
        for (int i = 0; i < 5; ++i) {
            JComponent component = components[i];
            component.setBounds(x, 0, contentWidths[i], height);
            component.validate();
            x += contentWidths[i];
        }
    }

    @NotNull
    private static int[] calcComponentsWidths(int width, float proportion1, float proportion2) {
        int dividersTotalWidth = ThreeDiffSplitter.getDividerWidth() * 2;
        int contentsTotalWidth = Math.max(width - dividersTotalWidth, 0);
        int[] contentWidths = new int[5];
        contentWidths[1] = ThreeDiffSplitter.getDividerWidth();
        contentWidths[3] = ThreeDiffSplitter.getDividerWidth();
        contentWidths[0] = (int)((float)contentsTotalWidth * proportion1);
        contentWidths[4] = (int)((float)contentsTotalWidth * proportion2);
        contentWidths[2] = Math.max(contentsTotalWidth - contentWidths[0] - contentWidths[4], 0);
        return contentWidths;
    }

    @Override
    public Dimension getMinimumSize() {
        int width = ThreeDiffSplitter.getDividerWidth() * 2;
        int height = 0;
        for (JComponent jComponent : this.myContents) {
            Dimension size = jComponent.getMinimumSize();
            width += size.width;
            height = Math.max(height, size.height);
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = ThreeDiffSplitter.getDividerWidth() * 2;
        int height = 0;
        for (JComponent jComponent : this.myContents) {
            Dimension size = jComponent.getPreferredSize();
            width += size.width;
            height = Math.max(height, size.height);
        }
        return new Dimension(width, height);
    }

    private static int getDividerWidth() {
        return JBUI.scale((int)Registry.intValue((String)"diff.divider.width"));
    }

    private class Divider
    extends JPanel {
        @NotNull
        private final Side mySide;
        @Nullable
        private DiffSplitter.Painter myPainter;

        Divider(Side side) {
            this.mySide = side;
            this.enableEvents(48L);
            this.setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.myPainter != null) {
                this.myPainter.paint(g, this);
            }
        }

        public void setPainter(@Nullable DiffSplitter.Painter painter) {
            this.myPainter = painter;
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            int totalWidth;
            super.processMouseMotionEvent(e);
            if (e.getID() == 506 && (totalWidth = ThreeDiffSplitter.this.getWidth()) > 0) {
                Point point = SwingUtilities.convertPoint(this, e.getPoint(), ThreeDiffSplitter.this);
                float proportion = (float)this.mySide.select(point.x, totalWidth - point.x) / (float)totalWidth;
                ThreeDiffSplitter.this.setProportion(proportion, this.mySide);
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 500 && e.getClickCount() == 2) {
                if (ThreeDiffSplitter.this.areDefaultProportions()) {
                    ThreeDiffSplitter.this.expandMiddlePanel();
                } else {
                    ThreeDiffSplitter.this.resetProportions();
                }
                this.revalidate();
                this.repaint();
            }
        }
    }
}

