/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferableFileEditorStateSupport {
    @NotNull
    private static final Key<MyState> TRANSFERABLE_FILE_EDITOR_STATE = Key.create((String)"Diff.TransferableFileEditorState");
    private static final Condition<BinaryEditorHolder> IS_SUPPORTED = holder -> TransferableFileEditorStateSupport.getEditorState(holder.getEditor()) != null;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<? extends BinaryEditorHolder> myHolders;
    @NotNull
    private final List<? extends FileEditor> myEditors;
    private final boolean mySupported;
    private int myMasterIndex = 0;
    private boolean myDuringUpdate = true;

    public TransferableFileEditorStateSupport(@NotNull DiffSettingsHolder.DiffSettings settings, @NotNull List<? extends BinaryEditorHolder> holders, @NotNull Disposable disposable) {
        this.mySettings = settings;
        this.myHolders = holders;
        this.myEditors = ContainerUtil.map((Collection)ContainerUtil.filter(holders, IS_SUPPORTED), holder -> holder.getEditor());
        this.mySupported = this.myEditors.size() > 0;
        new MySynchronizer().install(disposable);
    }

    public boolean isSupported() {
        return this.mySupported;
    }

    public boolean isEnabled() {
        return this.mySettings.isSyncBinaryEditorSettings();
    }

    public void setEnabled(boolean enabled) {
        this.mySettings.setSyncBinaryEditorSettings(enabled);
    }

    public void syncStatesNow() {
        if (this.myEditors.size() < 2) {
            return;
        }
        FileEditor masterEditor = this.myHolders.get(this.myMasterIndex).getEditor();
        this.syncStateFrom(masterEditor);
    }

    @NotNull
    public AnAction createToggleAction() {
        return new ToggleSynchronousEditorStatesAction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        this.myDuringUpdate = false;
        if (!this.isEnabled()) {
            return;
        }
        MyState state = (MyState)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE);
        if (state == null) {
            return;
        }
        int newMasterIndex = state.getMasterIndex();
        if (newMasterIndex < this.myHolders.size()) {
            this.myMasterIndex = newMasterIndex;
        }
        try {
            this.myDuringUpdate = true;
            for (BinaryEditorHolder binaryEditorHolder : this.myHolders) {
                state.restoreContextData(binaryEditorHolder.getEditor());
            }
            this.syncStatesNow();
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (!this.isEnabled()) {
            return;
        }
        MyState state = new MyState(this.myMasterIndex);
        context.putUserData(TRANSFERABLE_FILE_EDITOR_STATE, (Object)state);
        state.storeContextData(this.myHolders.get(this.myMasterIndex).getEditor());
        for (BinaryEditorHolder binaryEditorHolder : this.myHolders) {
            state.storeContextData(binaryEditorHolder.getEditor());
        }
    }

    private void syncStateFrom(@NotNull FileEditor sourceEditor) {
        TransferableFileEditorState sourceState = TransferableFileEditorStateSupport.getEditorState(sourceEditor);
        if (sourceState == null) {
            return;
        }
        Map options = sourceState.getTransferableOptions();
        String id = sourceState.getEditorId();
        for (FileEditor fileEditor : this.myEditors) {
            if (sourceEditor == fileEditor) continue;
            this.updateEditor(fileEditor, id, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(@NotNull FileEditor editor, @NotNull String id, @NotNull Map<String, String> options) {
        try {
            this.myDuringUpdate = true;
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(editor);
            if (state != null && state.getEditorId().equals(id)) {
                state.setTransferableOptions(options);
                state.setCopiedFromMasterEditor();
                editor.setState((FileEditorState)state);
            }
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    @Nullable
    private static TransferableFileEditorState getEditorState(@NotNull FileEditor editor) {
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        return state instanceof TransferableFileEditorState ? (TransferableFileEditorState)state : null;
    }

    private static class MyState {
        private final Map<String, Map<String, String>> myMap = new HashMap<String, Map<String, String>>();
        private final int myMasterIndex;

        MyState(int masterIndex) {
            this.myMasterIndex = masterIndex;
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public void restoreContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState = TransferableFileEditorStateSupport.getEditorState(editor);
            if (editorState == null) {
                return;
            }
            Map<String, String> options = this.myMap.get(editorState.getEditorId());
            if (options == null) {
                return;
            }
            editorState.setTransferableOptions(options);
            editor.setState((FileEditorState)editorState);
        }

        public void storeContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState = TransferableFileEditorStateSupport.getEditorState(editor);
            if (editorState == null) {
                return;
            }
            if (!this.myMap.containsKey(editorState.getEditorId())) {
                this.myMap.put(editorState.getEditorId(), editorState.getTransferableOptions());
            }
        }
    }

    private static class ToggleSynchronousEditorStatesAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final TransferableFileEditorStateSupport mySupport;

        ToggleSynchronousEditorStatesAction(@NotNull TransferableFileEditorStateSupport support) {
            super("Synchronize Editors Settings", AllIcons.Actions.SyncPanels);
            this.mySupport = support;
        }

        public boolean isVisible() {
            return this.mySupport.isSupported();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySupport.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySupport.setEnabled(state);
            if (state) {
                this.mySupport.syncStatesNow();
            }
        }
    }

    private class MySynchronizer
    implements PropertyChangeListener {
        private MySynchronizer() {
        }

        public void install(@NotNull Disposable disposable) {
            if (TransferableFileEditorStateSupport.this.myEditors.size() < 2) {
                return;
            }
            for (FileEditor editor : TransferableFileEditorStateSupport.this.myEditors) {
                editor.addPropertyChangeListener((PropertyChangeListener)this);
            }
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    for (FileEditor editor : TransferableFileEditorStateSupport.this.myEditors) {
                        editor.removePropertyChangeListener((PropertyChangeListener)MySynchronizer.this);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TransferableFileEditorStateSupport.this.myDuringUpdate || !TransferableFileEditorStateSupport.this.isEnabled()) {
                return;
            }
            if (!(evt.getSource() instanceof FileEditor)) {
                return;
            }
            FileEditor editor = (FileEditor)evt.getSource();
            if (!editor.getComponent().isShowing()) {
                return;
            }
            Dimension size = editor.getComponent().getSize();
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            int holderIndex = ContainerUtil.indexOf((List)TransferableFileEditorStateSupport.this.myHolders, holder -> editor.equals(holder.getEditor()));
            if (holderIndex != -1) {
                TransferableFileEditorStateSupport.this.myMasterIndex = holderIndex;
            }
            TransferableFileEditorStateSupport.this.syncStateFrom(editor);
        }
    }
}

