/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Condition;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("Inspections", AllIcons.Ide.HectorOn, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> true)),
    ADVANCED("Syntax", AllIcons.Ide.HectorSyntax, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> {
        if (rangeHighlighter.getLayer() > 3000) {
            return false;
        }
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(rangeHighlighter);
        return info == null || info.getSeverity().compareTo(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) < 0;
    })),
    SIMPLE("None", AllIcons.Ide.HectorOff, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 1000));

    @NotNull
    private final String myText;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Condition<RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String text, Icon icon, Condition<RangeHighlighter> condition) {
        this.myText = text;
        this.myIcon = icon;
        this.myCondition = condition;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Condition<RangeHighlighter> getCondition() {
        return this.myCondition;
    }
}

