/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitialScrollPositionSupport {
    @NotNull
    public static Point[] doGetScrollingPositions(@NotNull List<? extends Editor> editors) {
        Point[] carets = new Point[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getScrollingPosition(editors.get(i));
        }
        return carets;
    }

    @NotNull
    public static LogicalPosition[] doGetCaretPositions(@NotNull List<? extends Editor> editors) {
        LogicalPosition[] carets = new LogicalPosition[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getCaretPosition(editors.get(i));
        }
        return carets;
    }

    @Nullable
    public static EditorsVisiblePositions doGetVisiblePositions(@NotNull List<? extends Editor> editors) {
        LogicalPosition[] carets = InitialScrollPositionSupport.doGetCaretPositions(editors);
        Point[] points = InitialScrollPositionSupport.doGetScrollingPositions(editors);
        return new EditorsVisiblePositions(carets, points);
    }

    public static void doMoveCaretsToPositions(@NotNull LogicalPosition[] positions, @NotNull List<? extends Editor> editors) {
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            editor.getCaretModel().moveToLogicalPosition(positions[i]);
        }
    }

    public static void doScrollToVisiblePositions(@NotNull EditorsVisiblePositions visiblePositions, @NotNull List<? extends Editor> editors) {
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            DiffUtil.scrollToPoint(editor, visiblePositions.myPoints[i], false);
        }
    }

    public static void doScrollToCaret(@NotNull List<? extends Editor> editors) {
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            DiffUtil.scrollToCaret(editor, false);
        }
    }

    public static boolean wasScrolled(@NotNull List<? extends Editor> editors) {
        for (Editor editor : editors) {
            if (editor == null) continue;
            if (editor.getCaretModel().getOffset() != 0) {
                return true;
            }
            if (editor.getScrollingModel().getVerticalScrollOffset() != 0) {
                return true;
            }
            if (editor.getScrollingModel().getHorizontalScrollOffset() == 0) continue;
            return true;
        }
        return false;
    }

    public static class EditorsVisiblePositions {
        public static final Key<EditorsVisiblePositions> KEY = Key.create((String)"Diff.EditorsVisiblePositions");
        @NotNull
        public final LogicalPosition[] myCaretPosition;
        @NotNull
        public final Point[] myPoints;

        public EditorsVisiblePositions(@NotNull LogicalPosition caretPosition, @NotNull Point points) {
            this(new LogicalPosition[]{caretPosition}, new Point[]{points});
        }

        public EditorsVisiblePositions(@NotNull LogicalPosition[] caretPosition, @NotNull Point[] points) {
            this.myCaretPosition = caretPosition;
            this.myPoints = points;
        }

        public boolean isSame(LogicalPosition ... caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (this.myCaretPosition.length != caretPosition.length) {
                return false;
            }
            for (int i = 0; i < caretPosition.length; ++i) {
                if (caretPosition[i].equals((Object)this.myCaretPosition[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class ThreesideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<ThreeSide, Integer> myScrollToLine;

        @Override
        public void processContext(@NotNull DiffRequest request) {
            super.processContext(request);
            this.myScrollToLine = (Pair)request.getUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request) {
            super.updateContext(request);
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE, null);
        }

        public void onSlowRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        protected abstract boolean doScrollToChange();

        protected abstract boolean doScrollToFirstChange();

        protected abstract boolean doScrollToLine();
    }

    public static abstract class TwosideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<Side, Integer> myScrollToLine;
        @Nullable
        protected DiffNavigationContext myNavigationContext;

        @Override
        public void processContext(@NotNull DiffRequest request) {
            super.processContext(request);
            this.myScrollToLine = (Pair)request.getUserData(DiffUserDataKeys.SCROLL_TO_LINE);
            this.myNavigationContext = (DiffNavigationContext)request.getUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request) {
            super.updateContext(request);
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, null);
            request.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, null);
        }

        public void onSlowRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myNavigationContext != null) {
                return;
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToContext();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        protected abstract boolean doScrollToChange();

        protected abstract boolean doScrollToFirstChange();

        protected abstract boolean doScrollToContext();

        protected abstract boolean doScrollToLine();
    }

    private static abstract class SideInitialScrollHelper
    extends InitialScrollHelperBase {
        private SideInitialScrollHelper() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            return InitialScrollPositionSupport.doGetCaretPositions(this.getEditors());
        }

        @Override
        @Nullable
        protected EditorsVisiblePositions getVisiblePositions() {
            return InitialScrollPositionSupport.doGetVisiblePositions(this.getEditors());
        }

        protected boolean doScrollToPosition() {
            List<? extends Editor> editors = this.getEditors();
            if (this.myCaretPosition == null || this.myCaretPosition.length != editors.size()) {
                return false;
            }
            InitialScrollPositionSupport.doMoveCaretsToPositions(this.myCaretPosition, editors);
            try {
                this.disableSyncScroll(true);
                if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(this.myCaretPosition)) {
                    InitialScrollPositionSupport.doScrollToVisiblePositions(this.myEditorsPosition, editors);
                } else {
                    InitialScrollPositionSupport.doScrollToCaret(editors);
                }
            }
            finally {
                this.disableSyncScroll(false);
            }
            return true;
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        protected abstract void disableSyncScroll(boolean var1);
    }

    public static abstract class InitialScrollHelperBase {
        protected boolean myShouldScroll = true;
        @Nullable
        protected DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        protected EditorsVisiblePositions myEditorsPosition;
        @Nullable
        protected LogicalPosition[] myCaretPosition;

        public void processContext(@NotNull DiffRequest request) {
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)request.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorsPosition = (EditorsVisiblePositions)request.getUserData(EditorsVisiblePositions.KEY);
            this.myCaretPosition = (LogicalPosition[])request.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
        }

        public void updateContext(@NotNull DiffRequest request) {
            LogicalPosition[] carets = this.getCaretPositions();
            EditorsVisiblePositions visiblePositions = this.getVisiblePositions();
            request.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            request.putUserData(EditorsVisiblePositions.KEY, (Object)visiblePositions);
            request.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
        }

        @Nullable
        protected abstract LogicalPosition[] getCaretPositions();

        @Nullable
        protected abstract EditorsVisiblePositions getVisiblePositions();
    }
}

