/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextDiffViewerUtil {
    private static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result2.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result2, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorPopupMenu")).getChildren(null));
        return result2;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        return new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.TextDiffSettings.KEY);
        if (settings == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        return settings;
    }

    @NotNull
    public static boolean[] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        List contents = request.getContents();
        int contentCount = contents.size();
        boolean[] result2 = new boolean[contentCount];
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length != contentCount) {
            LOG.warn("Invalid FORCE_READ_ONLY_CONTENTS key value: " + request);
            data = null;
        }
        for (int i = 0; i < contents.size(); ++i) {
            if (!DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{(UserDataHolder)contents.get(i), request, context}) && (data == null || !data[i])) continue;
            result2[i] = true;
        }
        return result2;
    }

    public static void installDocumentListeners(@NotNull DocumentListener listener2, @NotNull List<? extends Document> documents, @NotNull Disposable disposable) {
        for (Document document : ContainerUtil.newHashSet(documents)) {
            document.addDocumentListener(listener2, disposable);
        }
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i = 0; i < contents.size(); ++i) {
            for (int j = i + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request.toString()).append("\n");
            for (DiffContent content : contents) {
                message.append(content.toString()).append("\n");
            }
            LOG.warn(message.toString());
        }
    }

    public static boolean areEqualLineSeparators(@NotNull List<? extends DiffContent> contents) {
        return TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getLineSeparator);
    }

    public static boolean areEqualCharsets(@NotNull List<? extends DiffContent> contents) {
        boolean sameCharset = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getCharset);
        boolean sameBOM = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::hasBom);
        return sameCharset && sameBOM;
    }

    private static <T> boolean areEqualDocumentContentProperties(@NotNull List<? extends DiffContent> contents, @NotNull Function<DocumentContent, T> propertyGetter) {
        List properties = ContainerUtil.mapNotNull(contents, content -> {
            if (content instanceof EmptyContent) {
                return null;
            }
            return propertyGetter.fun((Object)((DocumentContent)content));
        });
        if (properties.size() < 2) {
            return true;
        }
        return ContainerUtil.newHashSet((Iterable)properties).size() == 1;
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        return ContainerUtil.filter(editors, editor -> !editor.isViewer());
    }

    public static class EditorActionsPopup {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends EditorEx> editors) {
            ContextMenuPopupHandler.Simple handler2 = new ContextMenuPopupHandler.Simple((ActionGroup)(this.myEditorPopupActions.isEmpty() ? null : new DefaultActionGroup(this.myEditorPopupActions)));
            for (EditorEx editorEx : editors) {
                editorEx.installPopupHandler(handler2);
            }
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate = false;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (this.myEditors.size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                editorEx.addPropertyChangeListener(this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : this.myEditors) {
                if (evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            super(context);
            this.myEditableEditors = editableEditors;
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            super("Disable Editing", null, AllIcons.Diff.Lock);
            this.myContext = context;
            this.mySettings = TextDiffViewerUtil.getTextSettings(context);
        }

        protected void applyDefaults() {
            if (this.isVisible()) {
                this.setSelected(this.isSelected());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.isSelected();
        }

        boolean isSelected() {
            return this.mySettings.isReadOnlyLock();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.setSelected(state);
        }

        void setSelected(boolean state) {
            this.mySettings.setReadOnlyLock(state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();
    }

    public static abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            super("Collapse Unchanged Fragments", AllIcons.Actions.Collapseall);
            this.mySettings = settings;
        }

        public boolean isVisible() {
            return this.mySettings.getContextRange() != -1;
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);
    }

    public static class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }
    }

    public static class IgnorePolicySettingAction
    extends EnumPolicySettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, IgnorePolicy ... policies) {
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull IgnorePolicy option2) {
            if (this.getValue() == option2) {
                return;
            }
            DiffUsageTriggerCollector.trigger("toggle.ignore.policy", option2);
            this.mySettings.setIgnorePolicy(option2);
        }

        @Override
        @NotNull
        protected IgnorePolicy getStoredValue() {
            return this.mySettings.getIgnorePolicy();
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getValueSubstitutes(@NotNull IgnorePolicy value) {
            if (value == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
                return ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.IGNORE_WHITESPACES});
            }
            if (value == IgnorePolicy.FORMATTING) {
                return ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.TRIM_WHITESPACES});
            }
            return ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT});
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy option2) {
            return option2.getText();
        }
    }

    public static class HighlightPolicySettingAction
    extends EnumPolicySettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, HighlightPolicy ... policies) {
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull HighlightPolicy option2) {
            if (this.getValue() == option2) {
                return;
            }
            DiffUsageTriggerCollector.trigger("toggle.highlight.policy", option2);
            this.mySettings.setHighlightPolicy(option2);
        }

        @Override
        @NotNull
        protected HighlightPolicy getStoredValue() {
            return this.mySettings.getHighlightPolicy();
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getValueSubstitutes(@NotNull HighlightPolicy value) {
            if (value == HighlightPolicy.BY_WORD_SPLIT) {
                return ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
            }
            if (value == HighlightPolicy.DO_NOT_HIGHLIGHT) {
                return ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE});
            }
            return ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy option2) {
            return option2.getText();
        }
    }

    private static abstract class EnumPolicySettingAction<T extends Enum>
    extends ComboBoxSettingAction<T> {
        @NotNull
        private final T[] myPolicies;

        EnumPolicySettingAction(@NotNull T[] policies) {
            assert (policies.length > 0);
            this.myPolicies = policies;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabledAndVisible(this.myPolicies.length > 1);
        }

        @Override
        @NotNull
        protected List<T> getAvailableOptions() {
            return ContainerUtil.sorted(Arrays.asList(this.myPolicies));
        }

        @Override
        @NotNull
        public T getValue() {
            T value = this.getStoredValue();
            if (ArrayUtil.contains(value, (Object[])this.myPolicies)) {
                return value;
            }
            List<T> substitutes = this.getValueSubstitutes(value);
            for (Enum substitute : substitutes) {
                if (!ArrayUtil.contains((Object)substitute, (Object[])this.myPolicies)) continue;
                return (T)substitute;
            }
            return this.myPolicies[0];
        }

        @NotNull
        protected abstract T getStoredValue();

        @NotNull
        protected abstract List<T> getValueSubstitutes(@NotNull T var1);
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myActions;

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getValue()));
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            return this.getActions();
        }

        @NotNull
        public DefaultActionGroup getActions() {
            if (this.myActions == null) {
                this.myActions = new DefaultActionGroup();
                for (T setting : this.getAvailableOptions()) {
                    this.myActions.add((AnAction)new MyAction(setting));
                }
            }
            return this.myActions;
        }

        @NotNull
        protected abstract List<T> getAvailableOptions();

        @NotNull
        protected abstract T getValue();

        protected abstract void setValue(@NotNull T var1);

        @NotNull
        protected abstract String getText(@NotNull T var1);

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T myOption;

            MyAction(T option2) {
                super(ComboBoxSettingAction.this.getText(option2));
                this.myOption = option2;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ComboBoxSettingAction.this.setValue(this.myOption);
            }
        }
    }
}

