/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.ThreesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final ThreesideContentPanel myContentPanel;
    @NotNull
    private final List<T> myHolders;
    @NotNull
    private final FocusTrackerSupport<ThreeSide> myFocusTrackerSupport;

    public ThreesideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        super(context, request);
        this.myHolders = this.createEditorHolders(factory);
        List<JComponent> titlePanel = this.createTitles();
        this.myFocusTrackerSupport = new FocusTrackerSupport.Threeside(this.myHolders);
        this.myContentPanel = new ThreesideContentPanel(this.myHolders, titlePanel);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications((UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
    }

    @Override
    protected void onDispose() {
        this.destroyEditorHolders();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected List<T> createEditorHolders(@NotNull EditorHolderFactory<T> factory) {
        List contents = this.myRequest.getContents();
        ArrayList<T> holders = new ArrayList<T>(3);
        for (int i = 0; i < 3; ++i) {
            DiffContent content = (DiffContent)contents.get(i);
            holders.add(factory.create(content, this.myContext));
        }
        return holders;
    }

    private void destroyEditorHolders() {
        for (EditorHolder holder : this.myHolders) {
            Disposer.dispose((Disposable)holder);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        return DiffUtil.createSyncHeightComponents(DiffUtil.createSimpleTitles(this.myRequest));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getCurrentEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public ThreeSide getCurrentSide() {
        return this.myFocusTrackerSupport.getCurrentSide();
    }

    protected void setCurrentSide(@NotNull ThreeSide side) {
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    protected List<T> getEditorHolders() {
        return this.myHolders;
    }

    @NotNull
    protected T getCurrentEditorHolder() {
        return (T)((EditorHolder)this.getCurrentSide().select(this.getEditorHolders()));
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentSide().select(this.myRequest.getContents());
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return ((DiffContent)this.getCurrentSide().select(this.getRequest().getContents())).getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 3) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= factory.canShowContent(content, context);
            wantShow |= factory.wantShowContent(content, context);
        }
        return canShow && wantShow;
    }

    protected class ShowPartialDiffAction
    extends DumbAwareAction {
        @NotNull
        protected final ThreeSide mySide1;
        @NotNull
        protected final ThreeSide mySide2;

        public ShowPartialDiffAction(PartialDiffMode mode, boolean hasFourSides) {
            String id;
            Icon icon = null;
            switch (mode) {
                case LEFT_MIDDLE: {
                    this.mySide1 = ThreeSide.LEFT;
                    this.mySide2 = ThreeSide.BASE;
                    id = "Diff.ComparePartial.Base.Left";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftMiddle;
                    break;
                }
                case RIGHT_MIDDLE: {
                    this.mySide1 = ThreeSide.RIGHT;
                    this.mySide2 = ThreeSide.BASE;
                    id = "Diff.ComparePartial.Base.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3MiddleRight;
                    break;
                }
                case MIDDLE_LEFT: {
                    this.mySide1 = ThreeSide.BASE;
                    this.mySide2 = ThreeSide.LEFT;
                    id = "Diff.ComparePartial.Base.Left";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftMiddle;
                    break;
                }
                case MIDDLE_RIGHT: {
                    this.mySide1 = ThreeSide.BASE;
                    this.mySide2 = ThreeSide.RIGHT;
                    id = "Diff.ComparePartial.Base.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3MiddleRight;
                    break;
                }
                case LEFT_RIGHT: {
                    this.mySide1 = ThreeSide.LEFT;
                    this.mySide2 = ThreeSide.RIGHT;
                    id = "Diff.ComparePartial.Left.Right";
                    if (hasFourSides) break;
                    icon = AllIcons.Diff.Compare3LeftRight;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            String text = ActionsBundle.message((String)"action.Diff.ComparePartial.Generic", (Object[])new Object[]{this.mySide1.getIndex(), this.mySide2.getIndex()});
            this.getTemplatePresentation().setText(text);
            this.getTemplatePresentation().setIcon(icon);
            ActionUtil.mergeFrom((AnAction)this, (String)id);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SimpleDiffRequest request = this.createRequest();
            DiffManager.getInstance().showDiff(ThreesideDiffViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ThreesideDiffViewer.this.myPanel));
        }

        @NotNull
        protected SimpleDiffRequest createRequest() {
            List contents = ThreesideDiffViewer.this.myRequest.getContents();
            List titles = ThreesideDiffViewer.this.myRequest.getContentTitles();
            return new SimpleDiffRequest(ThreesideDiffViewer.this.myRequest.getTitle(), (DiffContent)this.mySide1.select(contents), (DiffContent)this.mySide2.select(contents), (String)this.mySide1.select(titles), (String)this.mySide2.select(titles));
        }
    }

    protected static enum PartialDiffMode {
        LEFT_MIDDLE,
        RIGHT_MIDDLE,
        MIDDLE_LEFT,
        MIDDLE_RIGHT,
        LEFT_RIGHT;

    }
}

