/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends ThreesideDiffViewer<TextEditorHolder> {
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener = new MyVisibleAreaListener();
    @Nullable
    protected SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollSupport;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());

    public ThreesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        for (ThreeSide side : ThreeSide.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side));
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i = 0; i < 3; ++i) {
            if (!forceReadOnly[i]) continue;
            holders.get(i).getEditor().setViewer(true);
        }
        ((TextEditorHolder)ThreeSide.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        for (TextEditorHolder holder : holders) {
            DiffUtil.disableBlitting(holder.getEditor());
        }
        return holders;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        return DiffUtil.createSyncHeightComponents(DiffUtil.createTextTitles(this.myRequest, this.getEditors()));
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(ThreeSide.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.ThreesideSyncScrollSupport(this.getEditors(), scrollable1, scrollable2);
            this.myEditorSettingsAction.setSyncScrollSupport(this.mySyncScrollSupport);
        }
    }

    public void destroyEditorListeners() {
        this.getEditor(ThreeSide.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            if (disable) {
                this.mySyncScrollSupport.enterDisableScrollSection();
            } else {
                this.mySyncScrollSupport.exitDisableScrollSection();
            }
        }
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffViewerUtil.getTextSettings(this.myContext);
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        return TextDiffViewerUtil.createEditorPopupActions();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        return this.getEditor(this.getCurrentSide());
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        return this.getContent(this.getCurrentSide());
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        return this.myRequest.getContents();
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), holder -> holder.getEditor());
        }
        return this.myEditors;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        return this.myEditableEditors;
    }

    @NotNull
    public EditorEx getEditor(@NotNull ThreeSide side) {
        return (EditorEx)side.select(this.getEditors());
    }

    @NotNull
    public DocumentContent getContent(@NotNull ThreeSide side) {
        return (DocumentContent)side.select(this.getContents());
    }

    @Nullable
    public ThreeSide getEditorSide(@Nullable Editor editor) {
        if (this.getEditor(ThreeSide.BASE) == editor) {
            return ThreeSide.BASE;
        }
        if (this.getEditor(ThreeSide.RIGHT) == editor) {
            return ThreeSide.RIGHT;
        }
        if (this.getEditor(ThreeSide.LEFT) == editor) {
            return ThreeSide.LEFT;
        }
        return null;
    }

    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        DiffUtil.scrollEditor(this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @NotNull
    protected LogicalPosition transferPosition(@NotNull ThreeSide baseSide, @NotNull ThreeSide targetSide, @NotNull LogicalPosition position) {
        if (this.mySyncScrollSupport == null) {
            return position;
        }
        if (baseSide == targetSide) {
            return position;
        }
        SyncScrollSupport.SyncScrollable scrollable12 = this.mySyncScrollSupport.getScrollable12();
        SyncScrollSupport.SyncScrollable scrollable23 = this.mySyncScrollSupport.getScrollable23();
        int baseLine = baseSide == ThreeSide.LEFT ? scrollable12.transfer(Side.LEFT, position.line) : (baseSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.RIGHT, position.line) : position.line);
        int targetLine = targetSide == ThreeSide.LEFT ? scrollable12.transfer(Side.RIGHT, baseLine) : (targetSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.LEFT, baseLine) : baseLine);
        return new LogicalPosition(targetLine, position.column);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getCurrentContent().getNavigatable(LineCol.fromCaret((Editor)this.getCurrentEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return ThreesideDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    protected class TextShowPartialDiffAction
    extends ThreesideDiffViewer.ShowPartialDiffAction {
        public TextShowPartialDiffAction(ThreesideDiffViewer.PartialDiffMode mode, boolean hasFourSides) {
            super(mode, hasFourSides);
        }

        @Override
        @NotNull
        protected SimpleDiffRequest createRequest() {
            SimpleDiffRequest request = super.createRequest();
            ThreeSide currentSide = ThreesideTextDiffViewer.this.getCurrentSide();
            LogicalPosition currentPosition = DiffUtil.getCaretPosition(ThreesideTextDiffViewer.this.getCurrentEditor());
            if (currentSide == this.mySide1) {
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)currentPosition.line));
            } else if (currentSide == this.mySide2) {
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            } else {
                LogicalPosition position1 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide1, currentPosition);
                LogicalPosition position2 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide2, currentPosition);
                request.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)new LogicalPosition[]{position1, position2});
            }
            return request;
        }
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.ThreesideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return ThreesideTextDiffViewer.this.getEditors();
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            ThreesideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.scrollToLine((ThreeSide)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (ThreesideTextDiffViewer.this.mySyncScrollSupport != null) {
                ThreesideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            ThreesideTextDiffViewer.this.myContentPanel.repaint();
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(ThreesideTextDiffViewer.this.getTextSettings());
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            ThreeSide side = ThreesideTextDiffViewer.this.getEditorSide(editor);
            if (side == null) {
                return null;
            }
            return ThreesideTextDiffViewer.this.getContent(side).getNavigatable(new LineCol(line));
        }
    }
}

