/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.side.HolderPanel;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideContentPanel
extends JPanel {
    @NotNull
    private final DiffSplitter mySplitter;

    public TwosideContentPanel(@NotNull List<? extends EditorHolder> holders, @NotNull List<JComponent> titleComponents) {
        super(new BorderLayout());
        assert (holders.size() == 2);
        assert (titleComponents.size() == 2);
        this.mySplitter = new DiffSplitter();
        this.mySplitter.setFirstComponent(new HolderPanel((EditorHolder)Side.LEFT.select(holders), (JComponent)Side.LEFT.select(titleComponents)));
        this.mySplitter.setSecondComponent(new HolderPanel((EditorHolder)Side.RIGHT.select(holders), (JComponent)Side.RIGHT.select(titleComponents)));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.add((Component)((Object)this.mySplitter), "Center");
    }

    public void setBottomAction(@Nullable AnAction value) {
        this.mySplitter.setBottomAction(value);
    }

    public void setTopAction(@Nullable AnAction value) {
        this.mySplitter.setTopAction(value);
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter) {
        this.mySplitter.setPainter(painter);
    }

    public void repaintDivider() {
        this.mySplitter.repaintDivider();
    }

    @NotNull
    public DiffSplitter getSplitter() {
        return this.mySplitter;
    }
}

