/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final Logger LOG = Logger.getInstance(SimpleTextDiffProvider.class);
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.BY_CHAR, HighlightPolicy.DO_NOT_HIGHLIGHT};
    private static final HighlightPolicy[] CUSTOM_COMPUTER_HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final DiffUserDataKeysEx.DiffComputer myDiffComputer;

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        this(settings, rediff, disposable, null);
    }

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer) {
        this(settings, rediff, disposable, diffComputer, IGNORE_POLICIES, diffComputer != null ? CUSTOM_COMPUTER_HIGHLIGHT_POLICIES : HIGHLIGHT_POLICIES);
    }

    private SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myDiffComputer = diffComputer;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        return SimpleTextDiffProvider.compareRange(this.myDiffComputer, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, highlightPolicy, indicator);
    }

    @NotNull
    public static List<List<LineFragment>> compareRange(@Nullable DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        InnerFragmentsPolicy fragmentsPolicy = highlightPolicy.getFragmentsPolicy();
        if (diffComputer != null && linesRanges != null) {
            LOG.error(new Throwable("Unsupported operation: ranged diff with custom DiffComputer - " + diffComputer));
        }
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        if (linesRanges == null) {
            if (diffComputer != null) {
                List<LineFragment> fragments = diffComputer.compute(text1, text2, policy, fragmentsPolicy != InnerFragmentsPolicy.NONE, indicator);
                return Collections.singletonList(fragments);
            }
            List<LineFragment> fragments = comparisonManager.compareLinesInner(text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator);
            return Collections.singletonList(fragments);
        }
        ArrayList<List<LineFragment>> result2 = new ArrayList<List<LineFragment>>();
        for (Range range2 : linesRanges) {
            result2.add(comparisonManager.compareLinesInner(range2, text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator));
        }
        return result2;
    }

    public static class NoIgnore
    extends SimpleTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
            this(settings, rediff, disposable, null);
        }

        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer) {
            super(settings, rediff, disposable, diffComputer, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            return super.compare(text1, text2, indicator);
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
            return super.compare(text1, text2, (List)linesRanges, indicator);
        }
    }
}

