/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.FineMergeLineFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideTextDiffProvider
extends TextDiffProviderBase {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD};

    public SimpleThreesideTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        super(settings, rediff, disposable, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    @NotNull
    public List<FineMergeLineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        ComparisonPolicy comparisonPolicy = ignorePolicy.getComparisonPolicy();
        List sequences = ContainerUtil.list((Object[])new CharSequence[]{text1, text2, text3});
        List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
        indicator.checkCanceled();
        List lineFragments = ComparisonManager.getInstance().compareLines(text1, text2, text3, comparisonPolicy, indicator);
        indicator.checkCanceled();
        ArrayList<FineMergeLineFragment> result2 = new ArrayList<FineMergeLineFragment>(lineFragments.size());
        for (MergeLineFragment fragment : lineFragments) {
            MergeInnerDifferences innerDifferences;
            MergeConflictType conflictType = DiffUtil.getLineThreeWayDiffType(fragment, sequences, lineOffsets, comparisonPolicy);
            if (highlightPolicy.isFineFragments()) {
                List<CharSequence> chunks = SimpleThreesideTextDiffProvider.getChunks(fragment, sequences, lineOffsets, conflictType);
                innerDifferences = DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator);
            } else {
                innerDifferences = null;
            }
            result2.add(new FineMergeLineFragmentImpl(fragment, conflictType, innerDifferences));
        }
        return result2;
    }

    @NotNull
    private static List<CharSequence> getChunks(@NotNull MergeLineFragment fragment, @NotNull List<CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull MergeConflictType conflictType) {
        return ThreeSide.map(side -> {
            int endLine;
            if (!conflictType.isChange((ThreeSide)side)) {
                return null;
            }
            int startLine = fragment.getStartLine(side);
            if (startLine == (endLine = fragment.getEndLine(side))) {
                return null;
            }
            return DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), startLine, endLine);
        });
    }
}

