/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS, IgnorePolicy.FORMATTING};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.BY_CHAR, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContent myContent1;
    @NotNull
    private final DiffContent myContent2;
    @NotNull
    private final DiffIgnoredRangeProvider myProvider;

    @Nullable
    public static TwosideTextDiffProvider create(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1, content2 = (DiffContent)Side.RIGHT.select(request.getContents()));
        if (ignoredRangeProvider == null) {
            return null;
        }
        return new SmartTextDiffProvider(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    @Nullable
    public static TwosideTextDiffProvider.NoIgnore createNoIgnore(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1, content2 = (DiffContent)Side.RIGHT.select(request.getContents()));
        if (ignoredRangeProvider == null) {
            return null;
        }
        return new NoIgnore(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
        this(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myProject = project;
        this.myContent1 = content1;
        this.myContent2 = content2;
        this.myProvider = ignoredRangeProvider;
    }

    @Override
    @Nullable
    protected String getText(@NotNull IgnorePolicy option2) {
        if (option2 == IgnorePolicy.FORMATTING) {
            return this.myProvider.getDescription();
        }
        return null;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        if (ignorePolicy == IgnorePolicy.FORMATTING) {
            return this.compareIgnoreFormatting(text1, text2, lineOffsets1, lineOffsets2, linesRanges, highlightPolicy, indicator);
        }
        return SimpleTextDiffProvider.compareRange(null, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, highlightPolicy, indicator);
    }

    @NotNull
    private List<List<LineFragment>> compareIgnoreFormatting(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<Range> linesRanges, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        InnerFragmentsPolicy fragmentsPolicy = highlightPolicy.getFragmentsPolicy();
        List<TextRange> ignoredRanges1 = this.myProvider.getIgnoredRanges(this.myProject, text1, this.myContent1);
        List<TextRange> ignoredRanges2 = this.myProvider.getIgnoredRanges(this.myProject, text2, this.myContent2);
        BitSet ignored1 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges1);
        BitSet ignored2 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges2);
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        if (linesRanges == null) {
            List<LineFragment> fragments = comparisonManager.compareLinesWithIgnoredRanges(text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator);
            return Collections.singletonList(fragments);
        }
        ArrayList<List<LineFragment>> result2 = new ArrayList<List<LineFragment>>();
        for (Range range2 : linesRanges) {
            result2.add(comparisonManager.compareLinesWithIgnoredRanges(range2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator));
        }
        return result2;
    }

    @Nullable
    private static DiffIgnoredRangeProvider getIgnoredRangeProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (!Registry.is((String)"diff.smart.ignore.enabled")) {
            return null;
        }
        for (DiffIgnoredRangeProvider provider : (DiffIgnoredRangeProvider[])DiffIgnoredRangeProvider.EP_NAME.getExtensions()) {
            if (!provider.accepts(project, content1) || !provider.accepts(project, content2)) continue;
            return provider;
        }
        return null;
    }

    public static class NoIgnore
    extends SmartTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        private NoIgnore(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
            super(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            return super.compare(text1, text2, indicator);
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
            return super.compare(text1, text2, (List)linesRanges, indicator);
        }
    }
}

