/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.TextDiffProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffProviderBase
implements TextDiffProvider {
    private final TextDiffViewerUtil.IgnorePolicySettingAction myIgnorePolicySettingAction;
    private final TextDiffViewerUtil.HighlightPolicySettingAction myHighlightPolicySettingAction;

    public TextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        this.myIgnorePolicySettingAction = new MyIgnorePolicySettingAction(settings, ignorePolicies);
        this.myHighlightPolicySettingAction = new MyHighlightPolicySettingAction(settings, highlightPolicies);
        settings.addListener(new MyListener(rediff), disposable);
    }

    @Override
    @NotNull
    public List<AnAction> getToolbarActions() {
        return ContainerUtil.list((Object[])new AnAction[]{this.myIgnorePolicySettingAction, this.myHighlightPolicySettingAction});
    }

    @Override
    @NotNull
    public List<AnAction> getPopupActions() {
        return ContainerUtil.list((Object[])new AnAction[]{Separator.getInstance(), this.myIgnorePolicySettingAction.getActions(), Separator.getInstance(), this.myHighlightPolicySettingAction.getActions(), Separator.getInstance()});
    }

    @NotNull
    public IgnorePolicy getIgnorePolicy() {
        return (IgnorePolicy)((Object)this.myIgnorePolicySettingAction.getValue());
    }

    @NotNull
    public HighlightPolicy getHighlightPolicy() {
        return (HighlightPolicy)((Object)this.myHighlightPolicySettingAction.getValue());
    }

    public boolean isHighlightingDisabled() {
        return this.myHighlightPolicySettingAction.getValue() == HighlightPolicy.DO_NOT_HIGHLIGHT;
    }

    @Nullable
    protected String getText(@NotNull IgnorePolicy option2) {
        return null;
    }

    @Nullable
    protected String getText(@NotNull HighlightPolicy option2) {
        return null;
    }

    private static class MyListener
    implements TextDiffSettingsHolder.TextDiffSettings.Listener {
        @NotNull
        private final Runnable myRediff;

        MyListener(@NotNull Runnable rediff) {
            this.myRediff = rediff;
        }

        @Override
        public void highlightPolicyChanged() {
            this.myRediff.run();
        }

        @Override
        public void ignorePolicyChanged() {
            this.myRediff.run();
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        MyHighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, HighlightPolicy[] highlightPolicies) {
            super(settings, highlightPolicies);
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy option2) {
            return StringUtil.notNullize((String)TextDiffProviderBase.this.getText(option2), (String)super.getText(option2));
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        MyIgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, IgnorePolicy[] ignorePolicies) {
            super(settings, ignorePolicies);
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy option2) {
            return StringUtil.notNullize((String)TextDiffProviderBase.this.getText(option2), (String)super.getText(option2));
        }
    }
}

