/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TwosideTextDiffProviderBase
extends TextDiffProviderBase
implements TwosideTextDiffProvider {
    protected TwosideTextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
    }

    @Override
    @Nullable
    public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        LineOffsets lineOffsets2;
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        List<List<LineFragment>> fragments = this.doCompare(text1, text2, lineOffsets1, lineOffsets2 = LineOffsetsUtil.create(text2), null, indicator);
        if (fragments == null) {
            return null;
        }
        assert (fragments.size() == 1);
        return fragments.get(0);
    }

    @Override
    @Nullable
    public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(text2);
        return this.doCompare(text1, text2, lineOffsets1, lineOffsets2, linesRanges, indicator);
    }

    @Nullable
    private List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        if (!highlightPolicy.isShouldCompare()) {
            return null;
        }
        indicator.checkCanceled();
        List<List<LineFragment>> fragments = this.doCompare(text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, highlightPolicy, indicator);
        assert (fragments.size() == (linesRanges != null ? linesRanges.size() : 1));
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        boolean squashFragments = highlightPolicy.isShouldSquash();
        boolean trimFragments = ignorePolicy.isShouldTrimChunks();
        indicator.checkCanceled();
        return ContainerUtil.map(fragments, rangeFragments -> ComparisonManager.getInstance().processBlocks(rangeFragments, text1, text2, policy, squashFragments, trimFragments));
    }

    @NotNull
    protected abstract List<List<LineFragment>> doCompare(@NotNull CharSequence var1, @NotNull CharSequence var2, @NotNull LineOffsets var3, @NotNull LineOffsets var4, @Nullable List<Range> var5, @NotNull IgnorePolicy var6, @NotNull HighlightPolicy var7, @NotNull ProgressIndicator var8);
}

