/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.NonHideableIconGutterMark;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.ObjectUtils;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffGutterRenderer
extends GutterIconRenderer
implements NonHideableIconGutterMark {
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final String myTooltip;

    public DiffGutterRenderer(@NotNull Icon icon, @Nullable String tooltip) {
        this.myIcon = icon;
        this.myTooltip = tooltip;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    public boolean isNavigateAction() {
        return true;
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.LEFT;
    }

    @Nullable
    public AnAction getClickAction() {
        return DumbAwareAction.create(e -> this.performAction((AnActionEvent)e));
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    protected void performAction(@NotNull AnActionEvent e) {
        MouseEvent mouseEvent = (MouseEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), MouseEvent.class);
        if (mouseEvent == null || mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            this.handleMouseClick();
        }
    }

    protected abstract void handleMouseClick();
}

