/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AmendComponent {
    private static final Logger LOG = Logger.getInstance(AmendComponent.class);
    @NotNull
    private final RepositoryManager<? extends Repository> myRepoManager;
    @NotNull
    private final CheckinProjectPanel myCheckinPanel;
    @NotNull
    protected final JCheckBox myAmend;
    @Nullable
    private Map<VirtualFile, String> myMessagesForRoots;
    @Nullable
    private String myAmendedMessage;
    @Nullable
    private String myPreviousMessage;

    public AmendComponent(@NotNull Project project, @NotNull RepositoryManager<? extends Repository> repoManager, @NotNull CheckinProjectPanel panel2) {
        this(project, repoManager, panel2, DvcsBundle.message("commit.amend", new Object[0]));
    }

    public AmendComponent(final @NotNull Project project, @NotNull RepositoryManager<? extends Repository> repoManager, @NotNull CheckinProjectPanel panel2, @NotNull String title) {
        this.myRepoManager = repoManager;
        this.myCheckinPanel = panel2;
        this.myAmend = new NonFocusableCheckBox(title);
        this.myAmend.setMnemonic('m');
        this.myAmend.setToolTipText(DvcsBundle.message("commit.amend.tooltip", new Object[0]));
        this.myAmend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AmendComponent.this.myAmend.isSelected()) {
                    if (AmendComponent.this.myCheckinPanel.getCommitMessage().equals(AmendComponent.this.myPreviousMessage)) {
                        String message;
                        if (AmendComponent.this.myMessagesForRoots == null) {
                            AmendComponent.this.loadMessagesInModalTask(project);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)(message = AmendComponent.this.constructAmendedMessage()))) {
                            AmendComponent.this.myAmendedMessage = message;
                            AmendComponent.this.substituteCommitMessage(AmendComponent.this.myAmendedMessage);
                        }
                    }
                } else if (AmendComponent.this.myCheckinPanel.getCommitMessage().equals(AmendComponent.this.myAmendedMessage)) {
                    AmendComponent.this.myCheckinPanel.setCommitMessage(AmendComponent.this.myPreviousMessage);
                }
            }
        });
    }

    @Nullable
    private String constructAmendedMessage() {
        Set<VirtualFile> selectedRoots = this.getVcsRoots(this.getSelectedFilePaths());
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        if (this.myMessagesForRoots != null) {
            for (VirtualFile root : selectedRoots) {
                String message = this.myMessagesForRoots.get(root);
                if (message == null) continue;
                messages.add(message);
            }
        }
        return DvcsUtil.joinMessagesOrNull(messages);
    }

    public void refresh() {
        this.myPreviousMessage = this.myCheckinPanel.getCommitMessage();
        this.myAmend.setSelected(false);
    }

    @NotNull
    public Component getComponent() {
        return this.myAmend;
    }

    @NotNull
    public JCheckBox getCheckBox() {
        return this.myAmend;
    }

    private void loadMessagesInModalTask(@NotNull Project project) {
        try {
            this.myMessagesForRoots = (Map)ProgressManager.getInstance().runProcessWithProgressSynchronously(this::getLastCommitMessages, "Reading Commit Message...", true, project);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)("Couldn't load commit message of the commit to amend.\n" + e.getMessage()), (String)"Commit Message not Loaded");
            LOG.info((Throwable)e);
        }
    }

    private void substituteCommitMessage(@NotNull String newMessage) {
        if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.myPreviousMessage, (CharSequence)newMessage)) {
            VcsConfiguration.getInstance((Project)this.myCheckinPanel.getProject()).saveCommitMessage(this.myPreviousMessage);
            this.myCheckinPanel.setCommitMessage(newMessage);
        }
    }

    @Nullable
    private Map<VirtualFile, String> getLastCommitMessages() throws VcsException {
        HashMap<VirtualFile, String> messagesForRoots = new HashMap<VirtualFile, String>();
        for (VirtualFile root : this.getAffectedRoots()) {
            String message = this.getLastCommitMessage(root);
            messagesForRoots.put(root, message);
        }
        return messagesForRoots;
    }

    @NotNull
    protected Collection<VirtualFile> getAffectedRoots() {
        return this.myRepoManager.getRepositories().stream().filter(repo -> !repo.isFresh()).map(Repository::getRoot).filter(root -> this.myCheckinPanel.getRoots().contains(root)).collect(Collectors.toList());
    }

    @NotNull
    private List<FilePath> getSelectedFilePaths() {
        return ContainerUtil.map((Collection)this.myCheckinPanel.getFiles(), VcsUtil::getFilePath);
    }

    @NotNull
    protected abstract Set<VirtualFile> getVcsRoots(@NotNull Collection<? extends FilePath> var1);

    @Nullable
    protected abstract String getLastCommitMessage(@NotNull VirtualFile var1) throws VcsException;

    public boolean isAmend() {
        return this.myAmend.isSelected();
    }
}

