/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchManager {
    @NotNull
    private final DvcsBranchSettings myBranchSettings;
    @NotNull
    private final Map<BranchType, Collection<String>> myPredefinedFavoriteBranches = ContainerUtil.newHashMap();

    protected DvcsBranchManager(@NotNull DvcsBranchSettings settings, @NotNull BranchType[] branchTypes) {
        this.myBranchSettings = settings;
        for (BranchType type : branchTypes) {
            String defaultBranchName = this.getDefaultBranchName(type);
            if (StringUtil.isEmptyOrSpaces((String)defaultBranchName)) continue;
            this.myPredefinedFavoriteBranches.put(type, Collections.singleton(defaultBranchName));
        }
    }

    @Nullable
    protected String getDefaultBranchName(@NotNull BranchType type) {
        return null;
    }

    public boolean isFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName) {
        if (branchType == null) {
            return false;
        }
        String branchTypeName = branchType.getName();
        if (this.myBranchSettings.getFavorites().contains(branchTypeName, repository, branchName)) {
            return true;
        }
        if (this.myBranchSettings.getExcludedFavorites().contains(branchTypeName, repository, branchName)) {
            return false;
        }
        return this.isPredefinedAsFavorite(branchType, branchName);
    }

    private boolean isPredefinedAsFavorite(@NotNull BranchType type, @NotNull String branchName) {
        Collection<String> predefinedNames = this.myPredefinedFavoriteBranches.get(type);
        return predefinedNames != null && predefinedNames.contains(branchName);
    }

    public void setFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (branchType == null) {
            return;
        }
        String branchTypeName = branchType.getName();
        if (shouldBeFavorite) {
            this.myBranchSettings.getExcludedFavorites().remove(branchTypeName, repository, branchName);
            if (!this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getFavorites().add(branchTypeName, repository, branchName);
            }
        } else {
            this.myBranchSettings.getFavorites().remove(branchTypeName, repository, branchName);
            if (this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getExcludedFavorites().add(branchTypeName, repository, branchName);
            }
        }
    }
}

