/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final BranchActionGroupPopup myPopup;
    @NotNull
    protected final String myRepoTitleInfo;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition, @Nullable String dimensionKey) {
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        String title = this.myVcs.getDisplayName() + " Branches";
        this.myRepoTitleInfo = this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC ? " in " + DvcsUtil.getShortRepositoryName(currentRepository) : "";
        this.myPopup = new BranchActionGroupPopup(title + this.myRepoTitleInfo, this.myProject, preselectActionCondition, this.createActions(), dimensionKey);
        this.initBranchSyncPolicyIfNotInitialized();
        this.warnThatBranchesDivergedIfNeeded();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            this.myPopup.addToolbarAction((AnAction)new TrackReposSynchronouslyAction(this.myVcsSettings), true);
        }
    }

    @NotNull
    public ListPopup asListPopup() {
        return this.myPopup;
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (this.myRepositoryManager.shouldProposeSyncControl()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    private void notifyAboutSyncedBranches() {
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("Branch Operations Are Executed on All Roots", "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Disable...", () -> {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.myVcs.getConfigurable().getDisplayName());
            if (this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                notification.expire();
            }
        }));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    @NotNull
    private ActionGroup createActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        return popupGroup;
    }

    protected boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull LightActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected List<Repo> filterRepositoriesNotOnThisBranch(@NotNull String branch, @NotNull List<Repo> allRepositories) {
        return ContainerUtil.filter(allRepositories, repository -> !branch.equals(repository.getCurrentBranchName()));
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.isBranchesDiverged()) {
            this.myPopup.setWarning("Branches have diverged");
        }
    }

    private boolean isBranchesDiverged() {
        return this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl();
    }

    @NotNull
    protected abstract LightActionGroup createRepositoriesActions();

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup var1, @Nullable LightActionGroup var2);

    private static class TrackReposSynchronouslyAction
    extends ToggleAction
    implements DumbAware {
        private final DvcsSyncSettings myVcsSettings;

        TrackReposSynchronouslyAction(@NotNull DvcsSyncSettings vcsSettings) {
            super(DvcsBundle.message("sync.setting", new Object[0]), DvcsBundle.message("sync.setting.description", "repository"), null);
            this.myVcsSettings = vcsSettings;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.myVcsSettings.setSyncSetting(state ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        }
    }

    public static class MyMoreIndex {
        public static final int MAX_NUM = 8;
        public static final int DEFAULT_NUM = 5;
    }
}

