/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.google.common.collect.Lists;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickManager {
    private static final Logger LOG = Logger.getInstance(VcsCherryPickManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myProjectLevelVcsManager;
    @NotNull
    private final Set<CommitId> myIdsInProgress = ContainerUtil.newConcurrentSet();
    @NotNull
    private final BackgroundTaskQueue myTaskQueue;

    public VcsCherryPickManager(@NotNull Project project, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        this.myProject = project;
        this.myProjectLevelVcsManager = projectLevelVcsManager;
        this.myTaskQueue = new BackgroundTaskQueue(project, "Cherry-picking");
    }

    public void cherryPick(@NotNull VcsLog log2) {
        log2.requestSelectedDetails(details -> this.myTaskQueue.run(new CherryPickingTask(ContainerUtil.reverse((List)details))));
    }

    public boolean isCherryPickAlreadyStartedFor(@NotNull List<? extends CommitId> commits) {
        for (CommitId commitId : commits) {
            if (!this.myIdsInProgress.contains(commitId)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VcsCherryPicker getCherryPickerForCommit(@NotNull VcsFullCommitDetails commitDetails) {
        AbstractVcs vcs = this.myProjectLevelVcsManager.getVcsFor(commitDetails.getRoot());
        if (vcs == null) {
            return null;
        }
        VcsKey key = vcs.getKeyInstanceMethod();
        return this.getCherryPickerFor(key);
    }

    @Nullable
    public VcsCherryPicker getCherryPickerFor(@NotNull VcsKey key) {
        return (VcsCherryPicker)ContainerUtil.find((Object[])VcsCherryPicker.EXTENSION_POINT_NAME.getExtensions((AreaInstance)this.myProject), picker -> picker.getSupportedVcs().equals((Object)key));
    }

    public static VcsCherryPickManager getInstance(@NotNull Project project) {
        return (VcsCherryPickManager)ServiceManager.getService((Project)project, VcsCherryPickManager.class);
    }

    private class CherryPickingTask
    extends Task.Backgroundable {
        @NotNull
        private final List<? extends VcsFullCommitDetails> myAllDetailsInReverseOrder;
        @NotNull
        private final ChangeListManagerEx myChangeListManager;

        CherryPickingTask(List<? extends VcsFullCommitDetails> detailsInReverseOrder) {
            super(VcsCherryPickManager.this.myProject, "Cherry-Picking");
            this.myAllDetailsInReverseOrder = detailsInReverseOrder;
            this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)this.myProject);
            this.myChangeListManager.blockModalNotifications();
        }

        @Nullable
        private VcsCherryPicker getCherryPickerOrReportError(@NotNull VcsFullCommitDetails details) {
            CommitId commitId = new CommitId((Hash)details.getId(), details.getRoot());
            if (VcsCherryPickManager.this.myIdsInProgress.contains(commitId)) {
                this.showError("Cherry pick process is already started for commit " + commitId.getHash().toShortString() + " from root " + commitId.getRoot().getName());
                return null;
            }
            VcsCherryPickManager.this.myIdsInProgress.add(commitId);
            VcsCherryPicker cherryPicker = VcsCherryPickManager.this.getCherryPickerForCommit(details);
            if (cherryPicker == null) {
                this.showError("Cherry pick is not supported for commit " + ((Hash)details.getId()).toShortString() + " from root " + details.getRoot().getName());
                return null;
            }
            return cherryPicker;
        }

        public void showError(@NotNull String message) {
            VcsNotifier.getInstance(this.myProject).notifyWeakError(message);
            LOG.warn(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            try {
                boolean isOk = true;
                MultiMap<VcsCherryPicker, VcsFullCommitDetails> groupedCommits = this.createArrayMultiMap();
                for (VcsFullCommitDetails vcsFullCommitDetails : this.myAllDetailsInReverseOrder) {
                    VcsCherryPicker cherryPicker = this.getCherryPickerOrReportError(vcsFullCommitDetails);
                    if (cherryPicker == null) {
                        isOk = false;
                        break;
                    }
                    groupedCommits.putValue((Object)cherryPicker, (Object)vcsFullCommitDetails);
                }
                if (isOk) {
                    for (Map.Entry entry : groupedCommits.entrySet()) {
                        ((VcsCherryPicker)entry.getKey()).cherryPick((List)Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
                    }
                }
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myChangeListManager.unblockModalNotifications();
                    for (VcsFullCommitDetails vcsFullCommitDetails : this.myAllDetailsInReverseOrder) {
                        VcsCherryPickManager.this.myIdsInProgress.remove(new CommitId((Hash)vcsFullCommitDetails.getId(), vcsFullCommitDetails.getRoot()));
                    }
                });
            }
        }

        @NotNull
        public MultiMap<VcsCherryPicker, VcsFullCommitDetails> createArrayMultiMap() {
            return new MultiMap<VcsCherryPicker, VcsFullCommitDetails>(){

                @NotNull
                protected Collection<VcsFullCommitDetails> createCollection() {
                    return new ArrayList<VcsFullCommitDetails>();
                }
            };
        }
    }
}

