/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushLogTreeUtil {
    public static final String EDIT_MODE_PROP = "tree.edit.mode";

    @Nullable
    public static Object getTagAtForRenderer(CheckboxTree.CheckboxTreeCellRenderer renderer2, MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            Rectangle rectangle = tree.getPathBounds(path);
            assert (rectangle != null);
            int dx = e.getX() - rectangle.x;
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            int row2 = tree.getRowForLocation(e.getX(), e.getY());
            tree.getCellRenderer().getTreeCellRendererComponent(tree, treeNode, false, false, true, row2, true);
            if (treeNode instanceof RepositoryNode) {
                RepositoryNode repositoryNode = (RepositoryNode)((Object)treeNode);
                int checkBoxWidth = repositoryNode.isCheckboxVisible() ? renderer2.getCheckbox().getWidth() : 0;
                tag = renderer2.getTextRenderer().getFragmentTagAt(dx - checkBoxWidth);
            } else {
                tag = renderer2.getTextRenderer().getFragmentTagAt(dx);
            }
        }
        return tag;
    }

    public static SimpleTextAttributes addTransparencyIfNeeded(@NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes baseStyle2, boolean isActive) {
        if (isActive) {
            return baseStyle2;
        }
        Color color = (Color)ObjectUtils.chooseNotNull((Object)baseStyle2.getFgColor(), (Object)component.getForeground());
        return new SimpleTextAttributes(baseStyle2.getStyle(), ColorUtil.toAlpha((Color)color, (int)85));
    }
}

