/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
DataProvider {
    private static final String ID = "Vcs.Push.Dialog";
    protected final Project myProject;
    private final PushLog myListPanel;
    protected final PushController myController;
    private final Map<PushSupport, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myPushAction;
    @NotNull
    private final List<ActionWrapper> myAdditionalActions;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        super(project, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myController = new PushController(project, this, selectedRepositories, currentRepo);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.Push.Actions");
        this.myAdditionalActions = StreamEx.of((Object[])group.getChildren(null)).select(PushActionBase.class).map(action -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action))).toList();
        this.init();
        this.updateOkActions();
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Push Commits");
    }

    protected JComponent createCenterPanel() {
        JPanel optionsPanel = this.createOptionsPanel();
        return JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)optionsPanel);
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowx"));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            optionsPanel.add((Component)panel2);
        }
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        return optionsPanel;
    }

    protected String getDimensionServiceKey() {
        return ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myPushAction = new ComplexPushAction(this.myAdditionalActions);
        this.myPushAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myPushAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        return actions.toArray(new Action[0]);
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    @NotNull
    public Map<PushSupport, Collection<PushInfo>> getSelectedPushSpecs() {
        return this.myController.getSelectedPushSpecs();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        return this.myPushAction;
    }

    protected String getHelpId() {
        return ID;
    }

    @Override
    public void push(final boolean forcePush) {
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, "Pushing...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                VcsPushDialog.this.myController.push(forcePush);
            }
        });
    }

    @Override
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity) {
        PrePushHandler.Result result2 = this.runPrePushHandlersInModalTask();
        if (result2 == PrePushHandler.Result.OK) {
            activity.queue();
            this.close(0);
        } else if (result2 == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result2 == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), "Checking Commits...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessage;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessage = failedHandler + " has been cancelled.\n";
                    } else {
                        super.onThrowable(cause);
                        suggestionMessage = failedHandler + " has failed. See log for more details.\n";
                    }
                    suggestionMessage = skippedHandlers.isEmpty() ? suggestionMessage + "Would you like to push anyway or cancel the push completely?" : suggestionMessage + "Would you like to skip all remaining pre-push steps and push, or cancel the push completely?";
                    this.suggestToSkipOrPush(suggestionMessage);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush("Would you like to skip all pre-push steps and push, or cancel the push completely?");
            }

            private void suggestToSkipOrPush(@NotNull String message) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)"Push", (String)"&Push Anyway", (String)"&Cancel", (Icon)UIUtil.getWarningIcon()) == 0) {
                    result2.set(PrePushHandler.Result.OK);
                } else {
                    result2.set(PrePushHandler.Result.ABORT);
                }
            }
        }.queue();
        return result2.get();
    }

    public void updateOkActions() {
        this.myPushAction.setEnabled(this.canPush());
        for (ActionWrapper wrapper2 : this.myAdditionalActions) {
            wrapper2.update();
        }
    }

    public void enableOkActions(boolean value) {
        this.myPushAction.setEnabled(value);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2 = this.myAdditionalPanels.get(support);
        return panel2 == null ? null : panel2.getValue();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsPushUi.VCS_PUSH_DIALOG.is(dataId)) {
            return this;
        }
        return null;
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushUi myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project, @NotNull VcsPushUi dialog2, @NotNull PushActionBase realAction) {
            super(realAction.getTemplatePresentation().getTextWithMnemonic());
            this.myProject = project;
            this.myDialog = dialog2;
            this.myRealAction = realAction;
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            boolean enabled = this.myRealAction.isEnabled(this.myDialog);
            this.setEnabled(enabled);
            this.putValue("ShortDescription", this.myRealAction.getDescription(this.myDialog, enabled));
        }
    }

    private class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final List<ActionWrapper> myOptions;

        private ComplexPushAction(List<ActionWrapper> additionalActions) {
            super("&Push");
            this.myOptions = additionalActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsPushDialog.this.push(false);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action : this.myOptions) {
                action.setEnabled(isEnabled);
            }
        }

        @NotNull
        public Action[] getOptions() {
            return VcsPushDialog.this.myAdditionalActions.toArray(new ActionWrapper[0]);
        }
    }
}

