/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryManager
implements Disposable,
VcsListener {
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = Topic.create((String)"VCS repository mapping updated", VcsRepositoryMappingListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK = new ReentrantReadWriteLock();
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories = ContainerUtil.newHashMap();
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories = ContainerUtil.newHashMap();
    @NotNull
    private final List<VcsRepositoryCreator> myRepositoryCreators;
    private volatile boolean myDisposed;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        return (VcsRepositoryManager)ObjectUtils.assertNotNull((Object)project.getComponent(VcsRepositoryManager.class));
    }

    public VcsRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myRepositoryCreators = Arrays.asList(VcsRepositoryCreator.EXTENSION_POINT_NAME.getExtensions((AreaInstance)project));
        project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    public void dispose() {
        this.myDisposed = true;
        try {
            this.REPO_LOCK.writeLock().lock();
            this.myRepositories.clear();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void directoryMappingChanged() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file2) {
        return this.getRepositoryForFile(file2, false);
    }

    @Deprecated
    @Nullable
    public Repository getRepositoryForFileQuick(@NotNull VirtualFile file2) {
        return this.getRepositoryForFile(file2, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file2, boolean quick) {
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file2);
        if (vcsRoot == null) {
            return null;
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root, boolean updateIfNeeded) {
        Repository result2;
        if (root == null) {
            return null;
        }
        try {
            this.REPO_LOCK.readLock().lock();
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            result2 = repo != null ? repo : this.myExternalRepositories.get(root);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && result2 == null && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root);
            try {
                this.REPO_LOCK.readLock().lock();
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return result2;
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        try {
            this.REPO_LOCK.readLock().lock();
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        try {
            this.REPO_LOCK.readLock().lock();
            ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
            return arrayList;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        try {
            HashMap repositories;
            this.MODIFY_LOCK.lock();
            try {
                this.REPO_LOCK.readLock().lock();
                if (this.myRepositories.containsKey(checkedRoot)) {
                    return;
                }
                repositories = ContainerUtil.newHashMap(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.keySet());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
            BackgroundTaskUtil.syncPublisher(this.myProject, VCS_REPOSITORY_MAPPING_UPDATED).mappingChanged();
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        HashMap newRootsMap = ContainerUtil.newHashMap();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            AbstractVcs vcs;
            VcsRepositoryCreator repositoryCreator;
            VirtualFile rootPath = root.getPath();
            if (rootPath == null || knownRoots.contains(rootPath) || (repositoryCreator = this.getRepositoryCreator(vcs = root.getVcs())) == null || (repository = repositoryCreator.createRepositoryIfValid(rootPath)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        return newRootsMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<VirtualFile> roots) {
        VirtualFile[] validRoots = this.myVcsManager.getAllVersionedRoots();
        return ContainerUtil.filter(roots, file2 -> !ArrayUtil.contains((Object)file2, (Object[])validRoots));
    }

    @Nullable
    private VcsRepositoryCreator getRepositoryCreator(@Nullable AbstractVcs vcs) {
        if (vcs == null) {
            return null;
        }
        return (VcsRepositoryCreator)ContainerUtil.find(this.myRepositoryCreators, creator -> creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod()));
    }

    @NotNull
    public String toString() {
        return "RepositoryManager{myRepositories: " + this.myRepositories + '}';
    }
}

