/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BranchActionGroup
extends ActionGroup
implements DumbAware {
    private boolean myIsFavorite;
    private LayeredIcon myIcon;
    private LayeredIcon myHoveredIcon;

    public BranchActionGroup() {
        super("", true);
        this.setIcons(AllIcons.Nodes.Favorite, EmptyIcon.ICON_16, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
    }

    protected void setIcons(@NotNull Icon favorite, @NotNull Icon notFavorite, @NotNull Icon favoriteOnHover, @NotNull Icon notFavoriteOnHover) {
        this.myIcon = new LayeredIcon(new Icon[]{favorite, notFavorite});
        this.myHoveredIcon = new LayeredIcon(new Icon[]{favoriteOnHover, notFavoriteOnHover});
        this.getTemplatePresentation().setIcon((Icon)this.myIcon);
        this.getTemplatePresentation().setSelectedIcon((Icon)this.myHoveredIcon);
        this.updateIcons();
    }

    private void updateIcons() {
        this.myIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
        this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
        this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
    }

    public boolean isFavorite() {
        return this.myIsFavorite;
    }

    public void setFavorite(boolean favorite) {
        this.myIsFavorite = favorite;
        this.updateIcons();
    }

    public void toggle() {
        this.setFavorite(!this.myIsFavorite);
    }

    public boolean hasIncomingCommits() {
        return false;
    }

    public boolean hasOutgoingCommits() {
        return false;
    }
}

