/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitListPanel
extends JPanel
implements TypeSafeDataProvider {
    private final List<VcsFullCommitDetails> myCommits;
    private final TableView<VcsFullCommitDetails> myTable;

    public CommitListPanel(@NotNull List<? extends VcsFullCommitDetails> commits, @Nullable String emptyText) {
        this.myCommits = new ArrayList<VcsFullCommitDetails>(commits);
        this.myTable = new TableView();
        this.updateModel();
        this.myTable.setSelectionMode(2);
        this.myTable.setStriped(true);
        if (emptyText != null) {
            this.myTable.getEmptyText().setText(emptyText);
        }
        this.setLayout(new BorderLayout());
        this.add(ScrollPaneFactory.createScrollPane(this.myTable));
    }

    public void addListSelectionListener(final @NotNull Consumer<VcsFullCommitDetails> listener2) {
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int i = lsm.getMaxSelectionIndex();
                int j = lsm.getMinSelectionIndex();
                if (i >= 0 && i == j) {
                    listener2.consume(CommitListPanel.this.myCommits.get(i));
                }
            }
        });
    }

    public void addListMultipleSelectionListener(final @NotNull Consumer<List<Change>> listener2) {
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List commits = CommitListPanel.this.myTable.getSelectedObjects();
                ArrayList changes2 = new ArrayList();
                ListIterator iterator = commits.listIterator(commits.size());
                while (iterator.hasPrevious()) {
                    changes2.addAll(((VcsFullCommitDetails)iterator.previous()).getChanges());
                }
                listener2.consume(CommittedChangesTreeBrowser.zipChanges(changes2));
            }
        });
    }

    public void registerDiffAction(@NotNull AnAction diffAction) {
        diffAction.registerCustomShortcutSet(diffAction.getShortcutSet(), this.myTable);
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (VcsDataKeys.CHANGES.equals(key)) {
            int[] rows = this.myTable.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            int row2 = rows[0];
            VcsFullCommitDetails commit2 = this.myCommits.get(row2);
            sink.put(key, (Object)commit2.getChanges().toArray(new Change[0]));
        }
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        return this.myTable;
    }

    public void clearSelection() {
        this.myTable.clearSelection();
    }

    public void setCommits(@NotNull List<? extends VcsFullCommitDetails> commits) {
        this.myCommits.clear();
        this.myCommits.addAll(commits);
        this.updateModel();
        this.myTable.repaint();
    }

    private void updateModel() {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(this.generateColumnsInfo(this.myCommits), this.myCommits, 0));
    }

    @NotNull
    private ColumnInfo[] generateColumnsInfo(@NotNull List<? extends VcsFullCommitDetails> commits) {
        ItemAndWidth hash = new ItemAndWidth("", 0);
        ItemAndWidth author = new ItemAndWidth("", 0);
        ItemAndWidth time = new ItemAndWidth("", 0);
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            hash = this.getMax(hash, CommitListPanel.getHash(vcsFullCommitDetails));
            author = this.getMax(author, CommitListPanel.getAuthor(vcsFullCommitDetails));
            time = this.getMax(time, CommitListPanel.getTime(vcsFullCommitDetails));
        }
        return new ColumnInfo[]{new CommitColumnInfo("Hash", hash.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getHash(commit2);
            }
        }, new ColumnInfo<VcsFullCommitDetails, String>("Subject"){

            public String valueOf(VcsFullCommitDetails commit2) {
                return commit2.getSubject();
            }
        }, new CommitColumnInfo("Author", author.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getAuthor(commit2);
            }
        }, new CommitColumnInfo("Author time", time.myItem){

            public String valueOf(VcsFullCommitDetails commit2) {
                return CommitListPanel.getTime(commit2);
            }
        }};
    }

    private ItemAndWidth getMax(ItemAndWidth current, String candidate) {
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(candidate);
        if (width > current.myWidth) {
            return new ItemAndWidth(candidate, width);
        }
        return current;
    }

    private static String getHash(VcsFullCommitDetails commit2) {
        return DvcsUtil.getShortHash(((Hash)commit2.getId()).toString());
    }

    private static String getAuthor(VcsFullCommitDetails commit2) {
        return VcsUserUtil.getShortPresentation(commit2.getAuthor());
    }

    private static String getTime(VcsFullCommitDetails commit2) {
        return DateFormatUtil.formatPrettyDateTime((long)commit2.getAuthorTime());
    }

    private static abstract class CommitColumnInfo
    extends ColumnInfo<VcsFullCommitDetails, String> {
        @NotNull
        private final String myMaxString;

        CommitColumnInfo(@NotNull String name, @NotNull String maxString) {
            super(name);
            this.myMaxString = maxString;
        }

        public String getMaxStringValue() {
            return this.myMaxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    private static class ItemAndWidth {
        private final String myItem;
        private final int myWidth;

        private ItemAndWidth(String item, int width) {
            this.myItem = item;
            this.myWidth = width;
        }
    }
}

