/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class CompareBranchesDiffPanel
extends JPanel {
    private final CompareBranchesHelper myHelper;
    private final String myBranchName;
    private final Project myProject;
    private final String myCurrentBranchName;
    private final CommitCompareInfo myCompareInfo;
    private final DvcsCompareSettings myVcsSettings;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    CompareBranchesDiffPanel(CompareBranchesHelper helper, String branchName, String currentBranchName, CommitCompareInfo compareInfo) {
        this.myHelper = helper;
        this.myProject = helper.getProject();
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myBranchName = branchName;
        this.myVcsSettings = helper.getDvcsCompareSettings();
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                CompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                CompareBranchesDiffPanel.this.refreshView();
            }
        });
        this.myChangesBrowser = new MyChangesBrowser(helper.getProject(), Collections.emptyList());
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)this.myChangesBrowser, "Center");
        this.refreshView();
    }

    private void refreshView() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        String currentBranchText = String.format("current working tree on <b><code>%s</code></b>", this.myCurrentBranchName);
        String otherBranchText = String.format("files in <b><code>%s</code></b>", this.myBranchName);
        this.myLabel.setText(String.format("<html>Difference between %s and %s:&emsp;<a href=\"\">Swap branches</a></html>", swapSides ? otherBranchText : currentBranchText, swapSides ? currentBranchText : otherBranchText));
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = DvcsBranchUtil.swapRevisions(diff);
        }
        this.myChangesBrowser.setChangesToDisplay(diff);
    }

    private class MyCopyChangesAction
    extends DumbAwareAction {
        MyCopyChangesAction() {
            super("Get from Branch", "Replace file content with its version from branch " + CompareBranchesDiffPanel.this.myBranchName, AllIcons.Actions.Download);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.GetVersion"));
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isEnabled = !CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible = CompareBranchesDiffPanel.this.myCompareInfo instanceof LocalCommitCompareInfo;
            e.getPresentation().setEnabled(isEnabled && isVisible);
            e.getPresentation().setVisible(isVisible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String title = String.format("Get from Branch '%s'", CompareBranchesDiffPanel.this.myBranchName);
            final List<Change> changes2 = CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(CompareBranchesDiffPanel.this.myProject, title);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges(changes2))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(title);
            new Task.Modal(CompareBranchesDiffPanel.this.myProject, "Loading Content from Branch", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        ((LocalCommitCompareInfo)CompareBranchesDiffPanel.this.myCompareInfo).copyChangesFromBranch(changes2, swapSides);
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)"Can't Copy Changes"));
                    }
                }

                public void onFinished() {
                    action.finish();
                    CompareBranchesDiffPanel.this.refreshView();
                }
            }.queue();
        }
    }

    private class MyChangesBrowser
    extends SimpleChangesBrowser {
        MyChangesBrowser(@NotNull Project project, List<Change> changes2) {
            super(project, false, true);
            this.setChangesToDisplay(changes2);
        }

        @Override
        public void setChangesToDisplay(@NotNull Collection<? extends Change> changes2) {
            List<Change> oldSelection = this.getSelectedChanges();
            super.setChangesToDisplay(changes2);
            this.myViewer.setSelectedChanges(DvcsBranchUtil.swapRevisions(oldSelection));
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            return ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
        }
    }
}

