/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log2.requestSelectedDetails(details -> {
            MultiMap grouped = this.groupCommits(project, (Collection)details, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project, log2);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project, @NotNull MultiMap<Repo, Hash> grouped) {
        AbstractRepositoryManager<Repo> manager = this.getRepositoryManager(project);
        return grouped.keySet().stream().noneMatch(arg_0 -> manager.isExternal(arg_0));
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project, @NotNull VcsLog log2) {
        MultiMap commitIds2 = this.groupCommits(project, ContainerUtil.getFirstItems((List)log2.getSelectedCommits(), (int)1000), CommitId::getRoot);
        if (commitIds2 == null) {
            return null;
        }
        MultiMap hashes = MultiMap.create();
        for (Map.Entry entry : commitIds2.entrySet()) {
            hashes.putValues(entry.getKey(), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), CommitId::getHash));
        }
        return hashes;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project, @NotNull Collection<T> commits, @NotNull Function<T, VirtualFile> rootGetter) {
        MultiMap map2 = MultiMap.create();
        for (T commit2 : commits) {
            Repo root = this.getRepositoryForRoot(project, (VirtualFile)rootGetter.fun(commit2));
            if (root == null) {
                return null;
            }
            map2.putValue(root, commit2);
        }
        return map2;
    }
}

