/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.VcsLogAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogOneCommitPerRepoAction<Repo extends Repository>
extends VcsLogAction<Repo> {
    @Override
    protected void actionPerformed(@NotNull Project project, @NotNull MultiMap<Repo, VcsFullCommitDetails> grouped) {
        Map<Repo, VcsFullCommitDetails> singleElementMap = this.convertToSingleElementMap(grouped);
        assert (singleElementMap != null);
        this.actionPerformed(project, singleElementMap);
    }

    @Override
    protected boolean isEnabled(@NotNull MultiMap<Repo, Hash> grouped) {
        return this.allValuesAreSingletons(grouped);
    }

    @Override
    protected abstract void actionPerformed(@NotNull Project var1, @NotNull Map<Repo, VcsFullCommitDetails> var2);

    private boolean allValuesAreSingletons(@NotNull MultiMap<Repo, Hash> grouped) {
        return ContainerUtil.and((Iterable)grouped.entrySet(), entry -> ((Collection)entry.getValue()).size() == 1);
    }

    @Nullable
    private Map<Repo, VcsFullCommitDetails> convertToSingleElementMap(@NotNull MultiMap<Repo, VcsFullCommitDetails> groupedCommits) {
        HashMap map2 = ContainerUtil.newHashMap();
        for (Map.Entry entry : groupedCommits.entrySet()) {
            Collection commits = (Collection)entry.getValue();
            if (commits.size() != 1) {
                return null;
            }
            map2.put(entry.getKey(), commits.iterator().next());
        }
        return map2;
    }
}

