/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateMasqueradingLexer
extends MasqueradingLexer {
    public static final IElementType MINUS_TYPE = new IElementType("MINUS", null);

    public TemplateMasqueradingLexer(@NotNull Lexer delegate) {
        super(delegate);
    }

    protected static abstract class MyLexer
    extends LexerBase {
        protected static final int LEXING_BY_SELF = 0;
        protected static final int DELEGATE_IS_LEXING_LINE = 1;
        protected static final int DELEGATE_IS_LEXING_BLOCK = 2;
        protected static final int EOF = 3;
        protected final int myIndent;
        protected final Lexer myDelegate;
        protected int myStartOffset;
        protected int myEndOffset;
        protected CharSequence myBuffer;
        protected int myState;
        protected IElementType myTokenType;
        protected int myTokenStart;
        protected int myTokenEnd;

        public MyLexer(int indent, Lexer delegateLexer) {
            this.myIndent = indent;
            this.myDelegate = delegateLexer;
        }

        protected abstract IElementType getIndentTokenType();

        protected abstract IElementType getEmbeddedContentTokenType();

        protected abstract int getEmbeddedCodeStartMarkerLength();

        protected int getDelegateState(int state) {
            return state;
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            this.myBuffer = buffer;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myState = initialState % 239;
            this.myTokenEnd = startOffset;
            if (this.myState == 1 || this.myState == 2) {
                this.myTokenEnd = this.myState == 1 ? this.findEol(startOffset) : this.findEndByIndent(startOffset);
                this.myDelegate.start(buffer, startOffset, this.myTokenEnd, this.getDelegateState(initialState / 239));
            } else {
                this.myDelegate.start(buffer, startOffset, startOffset, this.getDelegateState(0));
                this.advance();
            }
        }

        public int getState() {
            return this.myDelegate.getState() * 239 + this.myState;
        }

        @Nullable
        public IElementType getTokenType() {
            if (this.myState == 3) {
                return null;
            }
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenType();
            }
            return this.myTokenType;
        }

        @NotNull
        public String getTokenText() {
            if (this.myState == 3) {
                return "";
            }
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenText();
            }
            return super.getTokenText();
        }

        public int getTokenStart() {
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenStart();
            }
            return this.myTokenStart;
        }

        public int getTokenEnd() {
            if (this.myState == 1 || this.myState == 2) {
                return this.myDelegate.getTokenEnd();
            }
            return this.myTokenEnd;
        }

        public void advance() {
            if (this.myState == 1 || this.myState == 2) {
                this.myDelegate.advance();
                if (this.myDelegate.getTokenType() == null) {
                    this.myState = 0;
                    this.myTokenEnd = this.myDelegate.getBufferEnd();
                    this.advance();
                }
            } else {
                if (this.myTokenEnd == this.myEndOffset) {
                    this.myState = 3;
                    return;
                }
                this.myTokenStart = this.myTokenEnd;
                if (StringUtil.isWhiteSpace((char)this.myBuffer.charAt(this.myTokenStart))) {
                    this.myTokenType = this.getIndentTokenType();
                    this.myTokenEnd = this.findNonWhitespace(this.myTokenStart);
                    return;
                }
                int curIndent = this.calcIndent(this.myTokenStart);
                if (curIndent > this.myIndent) {
                    this.myTokenEnd = this.findEndByIndent(this.myTokenStart + 1);
                    if (this.prevLineWithMinusIsEmpty(this.myTokenStart)) {
                        this.myDelegate.start(this.myBuffer, this.myTokenStart, this.myTokenEnd, this.myDelegate.getState());
                        this.myState = 2;
                    } else {
                        this.myTokenType = this.getEmbeddedContentTokenType();
                    }
                    return;
                }
                int embeddedCodeStartMarkerLength = this.getEmbeddedCodeStartMarkerLength();
                if (embeddedCodeStartMarkerLength > 0) {
                    this.myTokenType = MINUS_TYPE;
                    this.myTokenEnd = this.myTokenStart + embeddedCodeStartMarkerLength;
                } else {
                    this.myTokenEnd = this.findEol(this.myTokenStart);
                    this.myDelegate.start(this.myBuffer, this.myTokenStart, this.myTokenEnd, this.getDelegateState(this.myDelegate.getState()));
                    this.myState = 1;
                }
            }
        }

        private boolean prevLineWithMinusIsEmpty(int offset) {
            int minusOffset = StringUtil.lastIndexOf((CharSequence)this.myBuffer, (char)'-', (int)this.myStartOffset, (int)offset);
            if (minusOffset == -1) {
                return false;
            }
            int eolPos = this.findEol(minusOffset);
            if (eolPos == -1) {
                return false;
            }
            return StringUtil.isEmptyOrSpaces((CharSequence)this.myBuffer.subSequence(minusOffset + 1, eolPos));
        }

        protected int findEndByIndent(int offset) {
            while (offset < this.myEndOffset) {
                if (offset > this.myStartOffset && !StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset)) && StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset - 1))) {
                    int indent = this.calcIndent(offset);
                    if (indent != -1 && indent <= this.myIndent) {
                        return offset;
                    }
                    offset = this.findEol(offset);
                    continue;
                }
                ++offset;
            }
            return offset;
        }

        protected int calcIndent(int offset) {
            if (offset == this.myStartOffset) {
                return this.myIndent;
            }
            int answer = 0;
            --offset;
            while (offset >= this.myStartOffset) {
                char c = this.myBuffer.charAt(offset);
                if (c == '\n') {
                    return answer;
                }
                if (!StringUtil.isWhiteSpace((char)c)) {
                    return -1;
                }
                ++answer;
                --offset;
            }
            return answer + this.myIndent;
        }

        protected int findNonWhitespace(int offset) {
            while (offset < this.myEndOffset) {
                if (!StringUtil.isWhiteSpace((char)this.myBuffer.charAt(offset))) {
                    return offset;
                }
                ++offset;
            }
            return offset;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            return this.myBuffer;
        }

        public int getBufferEnd() {
            return this.myEndOffset;
        }

        protected int findEol(int offset) {
            while (offset < this.myEndOffset) {
                if (this.myBuffer.charAt(offset) == '\n') {
                    return offset;
                }
                ++offset;
            }
            return offset;
        }
    }
}

