/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionMode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairConsumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionModes {
    private static final Logger LOG = Logger.getInstance(ExecutionMode.class);
    private static final PairConsumer<ExecutionMode, String> DEFAULT_TIMEOUT_CALLBACK = (mode, presentableCmdLine) -> LOG.error("Timeout (" + mode.getTimeout() + " sec) on executing: " + presentableCmdLine);

    public static class SameThreadMode
    extends ExecutionMode {
        private final int myTimeout;
        @NotNull
        private final PairConsumer<ExecutionMode, String> myTimeoutCallback;

        public SameThreadMode(boolean cancelable, @Nullable String title2, int timeout) {
            this(cancelable, title2, timeout, (PairConsumer<ExecutionMode, String>)DEFAULT_TIMEOUT_CALLBACK);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
        public SameThreadMode(boolean cancelable, @Nullable String title2, int timeout, @NotNull PairConsumer<ExecutionMode, String> timeoutCallback) {
            super(cancelable, null, title2, false, false, null);
            this.myTimeout = timeout;
            this.myTimeoutCallback = timeoutCallback;
        }

        public SameThreadMode(@Nullable String title2) {
            this(true, title2, -1);
        }

        public SameThreadMode(boolean cancelable) {
            this(cancelable, null, -1);
        }

        public SameThreadMode(int timeout) {
            this(false, null, timeout);
        }

        public SameThreadMode() {
            this(true);
        }

        @Override
        public int getTimeout() {
            return this.myTimeout;
        }

        @Override
        public void onTimeout(@NotNull ProcessHandler processHandler2, @NotNull String commandLineString, @NotNull ProcessOutput outputCollected) {
            super.onTimeout(processHandler2, commandLineString, outputCollected);
            String output = " stdout: " + outputCollected.getStdout() + "; stderr: " + outputCollected.getStderr();
            LOG.error("Timeout (" + this.getTimeout() + " sec) on executing: " + commandLineString + "; output collected: " + output);
        }

        @Override
        @Deprecated
        @NotNull
        public PairConsumer<ExecutionMode, String> getTimeoutCallback() {
            return this.myTimeoutCallback;
        }
    }

    public static class ModalProgressMode
    extends ExecutionMode {
        public ModalProgressMode(boolean cancelable, @Nullable String title, JComponent progressParentComponent) {
            super(cancelable, title, null, false, true, progressParentComponent);
        }

        public ModalProgressMode(@Nullable String title) {
            this(true, title, null);
        }

        public ModalProgressMode(@Nullable String title, JComponent progressParentComponent) {
            this(true, title, progressParentComponent);
        }
    }

    public static class BackGroundMode
    extends ExecutionMode {
        public BackGroundMode(boolean cancelable, @Nullable String title) {
            super(cancelable, title, null, true, false, null);
        }

        public BackGroundMode(@Nullable String title) {
            this(true, title);
        }
    }
}

