/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorRegistryImpl
extends ExecutorRegistry
implements Disposable,
BaseComponent {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    public static final String RUNNERS_GROUP = "RunnerActions";
    public static final String RUN_CONTEXT_GROUP = "RunContextGroupInner";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private final Map<String, Executor> myId2Executor = new THashMap();
    private final Set<String> myContextActionIdSet = new THashSet();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final Map<String, AnAction> myContextActionId2Action = new THashMap();
    private final Set<Trinity<Project, String, String>> myInProgress = Collections.synchronizedSet(new THashSet());

    synchronized void initExecutor(@NotNull Executor executor) {
        ActionGroup runContextAction;
        DumbAware toolbarAction;
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        if (executor instanceof ExecutorGroup) {
            ExecutorGroupActionGroup toolbarActionGroup = new ExecutorGroupActionGroup((ExecutorGroup)executor, x$0 -> new ExecutorAction((Executor)x$0));
            toolbarActionGroup.setPopup(true);
            Presentation presentation = toolbarActionGroup.getTemplatePresentation();
            presentation.setIcon(executor.getIcon());
            presentation.setText(executor.getStartActionText());
            presentation.setDescription(executor.getDescription());
            toolbarAction = toolbarActionGroup;
            runContextAction = new ExecutorGroupActionGroup((ExecutorGroup)executor, RunContextAction::new);
        } else {
            toolbarAction = new ExecutorAction(executor);
            runContextAction = new RunContextAction(executor);
        }
        Executor.ActionWrapper customizer = executor.runnerActionsGroupExecutorActionCustomizer();
        ExecutorRegistryImpl.registerAction(executor.getId(), (AnAction)(customizer != null ? customizer.wrap((AnAction)toolbarAction) : toolbarAction), RUNNERS_GROUP, this.myId2Action);
        ExecutorRegistryImpl.registerAction(executor.getContextActionId(), (AnAction)runContextAction, RUN_CONTEXT_GROUP, this.myContextActionId2Action);
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
    }

    private static void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        if (action == null) {
            actionManager.registerAction(actionId, anAction);
            map2.put(actionId, anAction);
            action = anAction;
        }
        ((DefaultActionGroup)actionManager.getAction(groupId)).add(action);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        ExecutorRegistryImpl.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        ExecutorRegistryImpl.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private static void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = (DefaultActionGroup)actionManager.getAction(groupId);
        if (group != null) {
            group.remove(actionManager.getAction(actionId));
            AnAction action = map2.get(actionId);
            if (action != null) {
                actionManager.unregisterAction(actionId);
                map2.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        return this.myExecutors.toArray(new Executor[0]);
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    public void initComponent() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                ExecutorRegistryImpl.this.myInProgress.add(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment, @NotNull ProcessHandler handler2) {
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project) {
                Set set2 = ExecutorRegistryImpl.this.myInProgress;
                synchronized (set2) {
                    Iterator it = ExecutorRegistryImpl.this.myInProgress.iterator();
                    while (it.hasNext()) {
                        if (project != ((Trinity)it.next()).first) continue;
                        it.remove();
                    }
                }
            }
        });
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            try {
                this.initExecutor(executor);
            }
            catch (Throwable t) {
                LOG.error("executor initialization failed: " + executor.getClass().getName(), t);
            }
        }
    }

    @NotNull
    private static Trinity<Project, String, String> createExecutionId(String executorId, @NotNull ExecutionEnvironment environment) {
        return Trinity.create((Object)environment.getProject(), (Object)executorId, (Object)environment.getRunner().getRunnerId());
    }

    public boolean isStarting(Project project, String executorId, String runnerId) {
        return this.myInProgress.contains(Trinity.create((Object)project, (Object)executorId, (Object)runnerId));
    }

    public boolean isStarting(@NotNull ExecutionEnvironment environment) {
        return this.isStarting(environment.getProject(), environment.getExecutor().getId(), environment.getRunner().getRunnerId());
    }

    public synchronized void dispose() {
        if (!this.myExecutors.isEmpty()) {
            for (Executor executor : new ArrayList<Executor>(this.myExecutors)) {
                this.deinitExecutor(executor);
            }
        }
        this.myExecutors = null;
    }

    public static class ExecutorGroupActionGroup
    extends ActionGroup
    implements DumbAware {
        private final ExecutorGroup myExecutorGroup;
        private final Function<Executor, AnAction> myChildConverter;

        private ExecutorGroupActionGroup(ExecutorGroup executorGroup, Function<Executor, AnAction> childConverter) {
            this.myExecutorGroup = executorGroup;
            this.myChildConverter = childConverter;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return this.myExecutorGroup.childExecutors().stream().map(this.myChildConverter).collect(Collectors.toList()).toArray(AnAction.EMPTY_ARRAY);
        }

        public void update(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(this.myExecutorGroup.isApplicable(project));
        }
    }

    private class ExecutorAction
    extends AnAction
    implements DumbAware,
    UpdateInBackground {
        private final Executor myExecutor;

        private ExecutorAction(final Executor executor) {
            super(executor.getStartActionText(), executor.getDescription(), (Icon)new IconLoader.LazyIcon(){

                protected Icon compute() {
                    return executor.getIcon();
                }
            });
            this.myExecutor = executor;
        }

        private boolean canRun(@NotNull Project project, @NotNull List<SettingsAndEffectiveTarget> pairs) {
            if (pairs.isEmpty()) {
                return false;
            }
            for (SettingsAndEffectiveTarget pair : pairs) {
                RunConfiguration configuration2 = pair.getConfiguration();
                if (configuration2 instanceof CompoundRunConfiguration && !this.canRun(project, ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets())) {
                    return false;
                }
                ProgramRunner runner = ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration2);
                if (runner != null && ExecutionTargetManager.canRun((RunConfiguration)configuration2, (ExecutionTarget)pair.getTarget()) && !ExecutorRegistryImpl.this.isStarting(project, this.myExecutor.getId(), runner.getRunnerId())) continue;
                return false;
            }
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            String text;
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedSettings = this.getSelectedConfiguration(project);
            boolean enabled = false;
            boolean hideDisabledExecutorButtons = false;
            if (selectedSettings != null) {
                if (DumbService.isDumb((Project)project) && !selectedSettings.getType().isDumbAware()) {
                    presentation.setEnabled(false);
                    return;
                }
                presentation.setIcon(this.getInformativeIcon(project, selectedSettings));
                RunConfiguration configuration2 = selectedSettings.getConfiguration();
                if (configuration2 instanceof CompoundRunConfiguration) {
                    enabled = this.canRun(project, ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets());
                } else {
                    ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)project);
                    enabled = this.canRun(project, Collections.singletonList(new SettingsAndEffectiveTarget(configuration2, target2)));
                    hideDisabledExecutorButtons = configuration2.hideDisabledExecutorButtons();
                }
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
                text = this.myExecutor.getStartActionText(configuration2.getName());
            } else {
                text = this.getTemplatePresentation().getTextWithMnemonic();
            }
            if (hideDisabledExecutorButtons) {
                presentation.setEnabledAndVisible(enabled);
            } else {
                presentation.setEnabled(enabled);
            }
            if (presentation.isVisible()) {
                presentation.setVisible(this.myExecutor.isApplicable(project));
            }
            presentation.setText(text);
        }

        private Icon getInformativeIcon(Project project, RunnerAndConfigurationSettings selectedConfiguration2) {
            RunnerIconProvider provider;
            Icon icon;
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            RunConfiguration configuration2 = selectedConfiguration2.getConfiguration();
            if (configuration2 instanceof RunnerIconProvider && (icon = (provider = (RunnerIconProvider)configuration2).getExecutorIcon(configuration2, this.myExecutor)) != null) {
                return icon;
            }
            List runningDescriptors2 = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)s -> s != null && s.getConfiguration() == selectedConfiguration2.getConfiguration()));
            runningDescriptors2 = ContainerUtil.filter(runningDescriptors2, descriptor -> {
                RunContentDescriptor contentDescriptor = executionManager.getContentManager().findContentDescriptor(this.myExecutor, descriptor.getProcessHandler());
                return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(this.myExecutor);
            });
            if (!configuration2.isAllowRunningInParallel() && !runningDescriptors2.isEmpty() && DefaultRunExecutor.EXECUTOR_ID.equals(this.myExecutor.getId())) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors2.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors2.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)String.valueOf(runningDescriptors2.size()));
        }

        @Nullable
        private RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull Project project) {
            return RunManager.getInstance((Project)project).getSelectedConfiguration();
        }

        private void run(@NotNull Project project, @Nullable RunConfiguration configuration2, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
            if (configuration2 instanceof CompoundRunConfiguration) {
                RunManager runManager = RunManager.getInstance((Project)project);
                for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets()) {
                    RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                    this.run(project, subConfiguration, runManager.findSettings(subConfiguration), dataContext);
                }
            } else {
                ExecutionEnvironmentBuilder builder2;
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)this.myExecutor, (RunnerAndConfigurationSettings)settings);
                if (builder2 == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.activeTarget().dataContext(dataContext).build());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
            RunnerAndConfigurationSettings selectedConfiguration2 = this.getSelectedConfiguration(project);
            if (selectedConfiguration2 != null) {
                this.run(project, selectedConfiguration2.getConfiguration(), selectedConfiguration2, e.getDataContext());
            }
        }
    }
}

