/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InputRedirectAware
extends RunConfiguration {
    public static final List<String> TYPES_WITH_REDIRECT_AWARE_UI = Arrays.asList("Application", "Java Scratch", "JUnit", "JarApplication");

    @NotNull
    public InputRedirectOptions getInputRedirectOptions();

    @Nullable
    public static InputRedirectOptions getInputRedirectOptions(@NotNull RunConfiguration runConfiguration) {
        return TYPES_WITH_REDIRECT_AWARE_UI.contains(runConfiguration.getType().getId()) ? ((InputRedirectAware)runConfiguration).getInputRedirectOptions() : null;
    }

    @Nullable
    public static File getInputFile(@NotNull RunConfiguration configuration2) {
        InputRedirectOptions inputRedirectOptions = InputRedirectAware.getInputRedirectOptions(configuration2);
        if (inputRedirectOptions == null || !inputRedirectOptions.isRedirectInput()) {
            return null;
        }
        String filePath = inputRedirectOptions.getRedirectInputPath();
        if (!StringUtil.isEmpty((String)filePath)) {
            String directory;
            filePath = FileUtil.toSystemDependentName((String)filePath);
            File file2 = new File(filePath);
            if (configuration2 instanceof CommonProgramRunConfigurationParameters && !FileUtil.isAbsolute((String)filePath) && (directory = ((CommonProgramRunConfigurationParameters)configuration2).getWorkingDirectory()) != null) {
                file2 = new File(new File(directory), filePath);
            }
            return file2;
        }
        return null;
    }

    @Deprecated
    public static final class InputRedirectOptionsImpl
    implements InputRedirectOptions {
        public static final String REDIRECT_INPUT = "REDIRECT_INPUT";
        public static final String INPUT_FILE = "INPUT_FILE";
        @Nullable
        public String myInputFile = null;
        public boolean myRedirectInput = false;

        public void readExternal(@NotNull Element element) {
            this.myRedirectInput = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)REDIRECT_INPUT, (String)"false"));
            this.myInputFile = JDOMExternalizerUtil.readField((Element)element, (String)INPUT_FILE);
        }

        public void writeExternal(Element element) {
            if (this.myRedirectInput) {
                JDOMExternalizerUtil.writeField((Element)element, (String)REDIRECT_INPUT, (String)"true");
            }
            if (this.myInputFile != null) {
                JDOMExternalizerUtil.writeField((Element)element, (String)INPUT_FILE, (String)this.myInputFile);
            }
        }

        @NotNull
        public InputRedirectOptionsImpl copy() {
            InputRedirectOptionsImpl options = new InputRedirectOptionsImpl();
            options.myRedirectInput = this.myRedirectInput;
            options.myInputFile = this.myInputFile;
            return options;
        }

        @Override
        public boolean isRedirectInput() {
            return this.myRedirectInput;
        }

        @Override
        public void setRedirectInput(boolean value) {
            this.myRedirectInput = value;
        }

        @Override
        @Nullable
        public String getRedirectInputPath() {
            return this.myInputFile;
        }

        @Override
        public void setRedirectInputPath(String value) {
            this.myInputFile = value;
        }
    }

    public static interface InputRedirectOptions {
        public boolean isRedirectInput();

        public void setRedirectInput(boolean var1);

        @Nullable
        public String getRedirectInputPath();

        public void setRedirectInputPath(String var1);
    }
}

